# ~/.bash_aliases
# set of bash aliases

alias grep='grep -i --color'
alias ll="ls -lha"
alias lll="ls -ltr |tail"
alias ltr="ls -ltr"
alias la='ls -A'
alias susu="sudo su -"
alias dfh="df -h"
alias dfhl="df -hl"
alias cp="cp -v"
alias man='LC_ALL='\'''\'' man'
alias mkdri='echo NESPI!; mkdir'
alias tailf='tail -f'
alias pdfcslatex='pdfcslatex -output-format pdf'
alias pdflatex='pdflatex -output-format pdf'
alias sshr='ssh -l root'
alias sshops="ssh -i ~/.ssh/autoinstall.key -l devops"
alias xssh='ssh -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
alias xscp='scp -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
alias xsshfs='sshfs -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
alias vimdiffwhite='vimdiff -c "set diffopt+=iwhite"'
alias redshift='redshift -l 49.02:17.12' # Kyjov
#alias redshift='redshift -l 49.19:16.60' # Brno
alias startvnc='nohup x11vnc --forever -display :0 &'
alias x11share='x11vnc -noipv6 -display :0 -auth /var/run/slim.auth -forever'
alias screen-master="screen -S master -c $HOME/.screenmaster"
alias lsblk-nice="lsblk -p -o NAME,VENDOR,MODEL,SIZE,TYPE,SERIAL,MOUNTPOINTS" 
alias mount-nice="mount |grep '^/dev'"
alias dd-nice="dd status=progress"

# python
alias pepik8='pep8 --ignore=E111,E121'
alias pylint_generic="pylint --disable=W --disable=C --disable=R *.py |less"
#alias pylint_ims_smt="pylint --init-hook=\"sys.path.append('../test/module_test')\" --disable=W --disable=C --disable=R *.py |less"
alias pylint_ims_smt="pylint --init-hook=\"sys.path.append('../test/module_test');sys.path.append('common')\" --disable=W --disable=C --disable=R *.py |less"

# serial access 
alias connect_nexx="cu -l /dev/serial/by-path/pci-0000\:00\:14.0-usb-0\:1.3\:1.0-port0 -s 57600"
alias connect_asus="cu -l /dev/serial/by-path/pci-0000\:00\:14.0-usb-0\:1.3\:1.0-port0 -s 115200"

# clipboard
alias pbcopy='xsel --clipboard --input'
alias pbpaste='xsel --clipboard --output'

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# git part
alias g.="git"
alias g.a="git add"
alias g.aa="git add ."
alias g.b="git branch"
alias g.ci="git commit"
alias g.cm="git commit -m"
alias g.co="git checkout"
alias g.g="git grep"
alias g.info="git remote show origin"
alias g.s="git status"
alias g.ss="git status --short"
alias g.sw="git switch"
alias g.unstage="git reset HEAD --"
# file actions
alias g.mv="git mv"
alias g.rm="git rm"
# repo
alias g.u="git pull"  # update local
alias g.p="git push"  # update remote
# file changes
alias g.d="git diff"
alias g.dt="git difftool"
alias g.dfs="git diff --name-status"
alias g.dfa="git diff --name-status --diff-filter=A"
alias g.dfm="git diff --name-status --diff-filter=M"
alias g.dfd="git diff --name-status --diff-filter=D"
# gerrit
alias g.gerrit="git push origin HEAD:refs/for/master"
# log output
alias g.l="git  log --oneline --decorate --all --graph"
alias g.tree="git log --graph --abbrev-commit --pretty=format:'%C(yellow)%h%Creset -%C(red)%d%Creset %s %Cgreen(%cr) %C(bold blue)<%an>%Creset'"
alias g.h="git log --graph --abbrev-commit --decorate --all --format=format:'%C(yellow)%h%C(reset) - %C(bold cyan)%aD%C(reset) %C(green)(%ar)%C(reset)%C(bold yellow)%d%C(reset)%n''          %C(white)%s%C(reset) %C(dim white)- %an%C(reset)'"
# edit modified 
alias g.vim="git status --short | awk '/ M / {print $2}' | xargs vim -o"

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# puppet
alias ee='eyaml encrypt'
alias ede='eyaml decrypt'

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# kubernetes part 
alias k.="kubectl"
alias k.a="kubectl apply"
alias k.g="kubectl get"
alias k.gp="kubectl get pod"
alias k.gd="kubectl get deploy"
alias k.gs="kubectl get svc"
alias k.gn="kubectl get nodes"
alias k.d="kubectl describe"
alias k.ge="kubectl get events --sort-by='.metadata.creationTimestamp' |tail -8"
alias k.e="kubectl explain"
# kubernetes plugins
alias k.x="kubectx"
alias k.ns="kubens"
alias k.login="kube-login all"
