# ~/.bash_functions
# set of bash functions

function mkdirr() {
    mkdir $1
    cd $1;
}

function datum() {
    date '+%-d. %-m. %Y %H:%M'
}

function time_stamp(){
	date '+%Y%m%d-%H%M%S'
}

function date_stamp(){
	date '+%Y%m%d'
}

function ghist() {
	history | grep -a "$1"
}

function ffind() {
	find -name "*$1*"
}

function misto() {
	du -sm "$@" |sort -n
}

function proxy_enable(){
  export http_proxy=http://127.0.0.1:3128
  export https_proxy=http://127.0.0.1:3128
}

function proxy_disable(){
  unset http_proxy
  unset https_proxy
}

function log_cmd(){
	echo  "script $HOME/.log/`date +%Y%m%d-%H%M%S`-$$.log";
}

function log_bash(){
  tstamp=$(date +%Y%m%d-%H%M%S)
	echo "bash log will be stored in"
  echo "  $HOME/.log/bash-$tstamp-$$.log"
	script $HOME/.log/bash-$tstamp-$$.log /bin/bash
}

function known_hosts_clean(){
 sed -i.bck "$1 d" $HOME/.ssh/known_hosts
}

function ssh_hosts_clean(){
 sed -i.bck "$1 d" $HOME/.ssh/known_hosts
}

function cdlast() {
#  cd $(ls -lrt | grep '^d' |tail -n 1 | awk '{printf $9 }')
#  cd $(ls -lrt | awk '/^d /;END{print $9}')
  cd $(ls -lrtd */ | awk 'END {print $9}')
}

function cdpen() {
#  cd $(ls -lrt | grep '^d' |tail -n 2 | head -1 | awk '{printf $9 }')
  cd $(ls -lrtd */ | awk '{ p=n; n=$9 } END { $0=p; print $(NF-1) }' )
}

function vimlast() {
  vim $(ls -lrt | awk '/^-/' | awk 'END{printf $9 }')
}
function load_yubi(){
  /usr/bin/ssh-add -s /usr/lib/x86_64-linux-gnu/pkcs11/opensc-pkcs11.so
}
