function parse_git_dirty {
  [[ $(git status --porcelain 2> /dev/null) ]] && echo "*"
}
function parse_git_branch {
  git branch --no-color 2> /dev/null | sed -e '/^[^*]/d' -e "s/* \(.*\)/ [\1$(parse_git_dirty)]/"
}

function giton() {
  export GIT_PS1_ENABLED="on"
}

function gitoff() {
  export GIT_PS1_ENABLED="off"
}

function git_ps1() {
  [[ "${GIT_PS1_ENABLED}" == "off" ]] && return
  echo $(parse_git_branch)
}

# export PS1="\n\t \[\033[32m\]\w\[\033[33m\]\$(git_ps1)\[\033[00m\] $ "
