#!/bin/bash

# load the library
. scripts/functions.sh

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# root check
if [ $UID -ne 0 ]  # Will the real "root" please stand up?
then
  echo "You are not root! Quiting ..."
  exit 1
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# source client configuration
CLIENT_FILE="tmp/client.txt"
if [ -z "$1" ];
then
  CLIENT="default"
else
  CLIENT=$1
  echo "$CLIENT" >$CLIENT_FILE
fi

if [ -f $CLIENT_FILE ];
then
  CLIENT=$(head -1 $CLIENT_FILE)
fi

if grep -qs ' CLIENT=[^ ]*' /proc/cmdline;
then
  export "$(sed -e 's/^.*\(CLIENT=[^ ]*\).*$/\1/' /proc/cmdline)"
fi

export CLIENT
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# default value - complete installation
export INSTALL_STAGE=100
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

if [ -e "clients/${CLIENT}/source.data" ]; then
  . "clients/${CLIENT}/source.data"
else
  echo "ERROR: no configuration file (client/${CLIENT}/source.data) found!"
  exit 1
fi


# pretest.sh storage.sh stage.sh portage-fetch.sh mount.sh
pretest.sh
mount.sh 
chroot /mnt/gentoo /bin/bash 
