#!/bin/bash

# load the library
. scripts/defaults.sh
. scripts/functions.sh

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# root check
if [ $UID -ne 0 ]  # Will the real "root" please stand up?
then
  echo "You are not root! Quiting ..."
  exit 1
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# source client configuration
CLIENT_FILE="tmp/client.txt"
if [ -z "$1" ];
then
  CLIENT="default"
else
  CLIENT=$1
  echo "$CLIENT" >$CLIENT_FILE
fi

if [ -f $CLIENT_FILE ];
then
  CLIENT=$(head -1 $CLIENT_FILE)
fi

if grep -qs ' CLIENT=[^ ]*' /proc/cmdline;
then
  export "$(sed -e 's/^.*\(CLIENT=[^ ]*\).*$/\1/' /proc/cmdline)"
fi

export CLIENT
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# default value - complete installation
export INSTALL_STAGE=100
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

if [ -e "clients/${CLIENT}/source.data" ]; then
  . "clients/${CLIENT}/source.data"
else
  echo "ERROR: no configuration file (client/${CLIENT}/source.data) found!"
  exit 1
fi


#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 1 - pre-chroot
script_list=(pretest.sh storage.sh stage.sh portage-fetch.sh mount.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-1
if [ $INSTALL_STAGE -le 1 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 2 - chroot - base system
#script_list=(password.sh portage-repo.sh cfg-localtime.sh cfg-keymap.sh cfg-locale.sh install-syslog.sh install-cron.sh cfg-fstab.sh grub.sh hostname.sh genkernel.sh networking.sh cfg-serial.sh utils.sh restart-hook.sh)
script_list=(password.sh portage-repo.sh cfg-fstab.sh grub.sh hostname.sh kernel-bin.sh networking.sh cfg-serial.sh utils.sh restart-hook.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -x
    set -o pipefail
    chroot /mnt/gentoo /bin/bash -e "/tmp/gen2/scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

if ! [ -d /mnt/gentoo/var/tmp/gen2 -o -d /var/tmp/gen2 ] ; then
  # copy the tooling
  cp -a /tmp/gen2 /mnt/gentoo/var/tmp
  sync

  bash scripts/umount_chroot.sh 2>&1 | tee /mnt/gentoo/var/tmp/umount_chroot.sh.log
  sync

  echo 
  echo "running reboot!"
  echo 
  reboot
fi
set -x

touch tmp/stage-2
if [ $INSTALL_STAGE -le 2 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 3 - installed system
#script_list=(portage-base.sh portage-system.sh portage-world.sh restart-hook-clean.sh)
script_list=(cfg-localtime.sh cfg-keymap.sh cfg-locale.sh install-syslog.sh install-cron.sh
cfg-editor.sh cfg-ssh.sh portage-base.sh portage-system.sh portage-system2.sh
cfg-acpid.sh restart-hook-clean.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-3
if [ $INSTALL_STAGE -le 3 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 4 - system configuration
script_list=(cfg-perl.sh cfg-cron.sh cfg-mail.sh cfg-sync.sh cfg-inputrc.sh cfg-locale.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-4
if [ $INSTALL_STAGE -le 4 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 5 - system service startup
script_list=(start-cron.sh start-syslog.sh start-netfilter.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-5
if [ $INSTALL_STAGE -le 5 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

exit 0
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 6 - copy licensed files into distfiles
script_list=(copy-oracle.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done
touch tmp/stage-6

if [ $INSTALL_STAGE -le 6 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 7 - emerge world
script_list=(start-cron.sh start-syslog.sh start-netfilter.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-7
if [ $INSTALL_STAGE -le 7 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# stage 8 - prepare etc
script_list=(etc-copy.sh etc-merge.sh)
for item in ${script_list[*]}
do
  start_check "$item"
  if [ $? -eq 1 ]; then
    begin_mark "$item"
    set -o pipefail
    bash -e "scripts/$item" 2>&1 | tee "tmp/$item.log" || mark_fail "$item"
    set +o pipefail
    done_mark "$item"
  fi
done

touch tmp/stage-8
if [ $INSTALL_STAGE -le 8 ]; then
  echo "Exiting in defined stage - $INSTALL_STAGE"
  exit 0
fi
