#!/bin/bash

# prevent download in case of off-line
GREP='/bin/grep'
NETSTAT='/bin/netstat'

# check connectivity via default route
$NETSTAT -rn |$GREP '0.0.0.0' 2>&1 >/dev/null
if [ $? -ne 0 ]; then
  # if I cannot proceed now move it to next day
  if [ ! -e /etc/cron.daily/distro-sync.sh ]; then
    ln -s /etc/cron.weekly/distro-sync.sh /etc/cron.daily/distro-sync.sh
  fi
  exit $?
fi 


echo "emerge --sync  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
#emerge-webrsync >/dev/null 2>&1
emerge --sync \
  |perl -e 'while(<>){if (/^receiving incremental file list/){exit;};print $_;}'
if [ ! -d /usr/portage/tmp ]; then
  echo "Creating /usr/portage/tmp"
  mkdir /usr/portage/tmp
fi

echo "emerge -uDNv world --fetchonly  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
emerge -uDNv world --fetchonly \
  |perl -e 'while(<>){if (/^>>> Fetching/){exit;};print $_;}'

echo 
echo "eix-update  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
eix-update

echo
echo "old distfiles check  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
find /usr/portage/distfiles -ctime +50 -exec ls -l {} \;

echo
echo "    find /usr/portage/distfiles -ctime +50 -exec ls -l {} \;"
echo "    find /usr/portage/distfiles -ctime +50 -exec rm {} \;"
echo

# clean next day run
if [ -e /etc/cron.daily/distro-sync.sh ]; then
  rm /etc/cron.daily/distro-sync.sh
fi
