#!/bin/bash

. $script_path/functions.sh

echo "-- $0 --"

cat >>~/.bashrc <<_EOF_

# man language
alias man='LC_ALL='\'''\'' man'
# history control
export HISTFILE=~/.bash_history
export HISTFILESIZE=2000000
export HISTSIZE=20000

mkdirr() {
  mkdir $1
  cd $1;
}

datum() {
  date '+%-d. %-m. %Y %H:%M'
}

ghist() {
  history | grep $1
}
_EOF_

cat >>~pforty/.bashrc <<_EOF_

# man language
alias man='LC_ALL='\'''\'' man'
# history control
export HISTFILE=~/.bash_history
export HISTFILESIZE=2000000
export HISTSIZE=20000
export HISTCONTROL="ignoreboth"

export PATH=$PATH:$HOME/bin

mkdirr() {
  mkdir $1
  cd $1;
}

datum() {
  date '+%-d. %-m. %Y %H:%M'
}

ghist() {
  history | grep $1
}
_EOF_

chown pforty:pforty ~pforty/.bashrc

done_mark
