#!/bin/bash

# permanent
MODULESFILE='/etc/conf.d/modules'
# temporary
#MODULESFILE=''

###############################################################################
#
# Load Modules
#
fw_modules=""

echo "Loading kernel modules ..."

# You should uncomment the line below and run it the first time just to
# ensure all kernel module dependencies are OK.  There is no need to run
# every time, however.

/sbin/depmod -a

# Unless you have kernel module auto-loading disabled, you should not
# need to manually load each of these modules.  Other than ip_tables,
# ip_conntrack, and some of the optional modules, I've left these
# commented by default.  Uncomment if you have any problems or if
# you have disabled module autoload.  Note that some modules must
# be loaded by another kernel module.

# core netfilter module
fw_modules="${fw_modules} ip_tables"
fw_modules="${fw_modules} ip6_tables"

# the stateful connection tracking module
fw_modules="${fw_modules} xt_conntrack"

# filter table module
fw_modules="${fw_modules} iptable_filter"
fw_modules="${fw_modules} ip6table_filter"

# mangle table module
# fw_modules="${fw_modules} iptable_mangle"

# nat table module
fw_modules="${fw_modules} iptable_nat"

# LOG target module
fw_modules="${fw_modules} xt_LOG"

# This is used to limit the number of packets per sec/min/hr
fw_modules="${fw_modules} xt_limit"

# masquerade target module
fw_modules="${fw_modules} ipt_MASQUERADE"
#fw_modules="${fw_modules} ip6t_MASQUERADE"

# filter using owner as part of the match
#fw_modules="${fw_modules} xt_owner"

# REJECT target drops the packet and returns an ICMP response.
# The response is configurable.  By default, connection refused.
# fw_modules="${fw_modules} ipt_REJECT"
# fw_modules="${fw_modules} ip6t_REJECT"

# This target allows packets to be marked in the mangle table
# fw_modules="${fw_modules} xt_mark"

# This target affects the TCP MSS
# fw_modules="${fw_modules} xt_tcpmss"

# This match allows multiple ports instead of a single port or range
# fw_modules="${fw_modules} xt_multiport"

# This match checks against the TCP flags
# fw_modules="${fw_modules} xt_state"

# The ftp nat module is required for non-PASV ftp support
#fw_modules="${fw_modules} nf_nat_ftp"

# general conntrack modules
fw_modules="${fw_modules} xt_conntrack"

# the module for full ftp connection tracking
#fw_modules="${fw_modules} nf_conntrack_ftp"

# the module for full irc connection tracking
#fw_modules="${fw_modules} nf_conntrack_irc"

# fw_modules="${fw_modules} nf_conntrack_amanda"
# fw_modules="${fw_modules} nf_conntrack_broadcast"
# fw_modules="${fw_modules} nf_conntrack_h323"
# fw_modules="${fw_modules} nf_conntrack_irc"
# fw_modules="${fw_modules} nf_conntrack_netbios_ns"
# fw_modules="${fw_modules} nf_conntrack_netlink"
# fw_modules="${fw_modules} nf_conntrack_pptp"
# fw_modules="${fw_modules} nf_conntrack_proto_gre"
# fw_modules="${fw_modules} nf_conntrack_proto_sctp"
# fw_modules="${fw_modules} nf_conntrack_proto_udplite"
# fw_modules="${fw_modules} nf_conntrack_sane"
# fw_modules="${fw_modules} nf_conntrack_sip"
# fw_modules="${fw_modules} nf_conntrack_snmp"
# fw_modules="${fw_modules} nf_conntrack_tftp"

# fw_modules="${fw_modules} nf_nat"
# fw_modules="${fw_modules} nf_nat_amanda"
# fw_modules="${fw_modules} nf_nat_ftp"
# fw_modules="${fw_modules} nf_nat_irc"
# fw_modules="${fw_modules} nf_nat_proto_sctp"
# fw_modules="${fw_modules} nf_nat_proto_udplite"
# fw_modules="${fw_modules} nf_nat_sip"
# fw_modules="${fw_modules} nf_nat_tftp"

for item in $fw_modules;
do
  echo "/sbin/modprobe $item"
done

echo 'INFO: GENTOO: add this line into "/etc/conf.d/modules"'


###############################################################################
# Get time stamp for a backup
day_time=$(date "+%Y%m%d_%H%M%S")

if [ "$MODULESFILE" != "" ]; then
  cp $MODULESFILE $MODULESFILE.bck-$day_time
  if [ "$?" != "0" ]; then
    echo "ERROR: cannot make a backup. Exiting ..."
    echo "ERROR: file ($MODULESFILE.bck-$day_time)"
    exit 1
  fi
fi

###############################################################################

grep "^fw_modules" $MODULESFILE
if [ "$?" == "0" ];
then
  sed -i.tmp "s/^fw_modules=.*/fw_modules='${fw_modules}'/" $MODULESFILE
else
  echo "fw_modules='${fw_modules}'" >>$MODULESFILE
  echo 'modules="${modules} ${fw_modules}"' >>$MODULESFILE
fi

# ensure than the modules merge
grep 'modules="${modules} ${fw_modules}"' $MODULESFILE
if [ "$?" != "0" ];
then
  echo 'modules="${modules} ${fw_modules}"' >>$MODULESFILE
fi
###############################################################################
