#!/bin/bash

#IPTABLES_SAVE="/var/lib/iptables/rules-save"

#if [ ! -d "/etc/firewall" ]; then
#  mkdir /etc/firewall
#fi
#
## changing firewall configuration location 
#today=$(date '+%Y%m%d')
#sed -i.bck-$today 's/IPTABLES_SAVE=".*"/IPTABLES_SAVE="\/etc\/firewall\/iptables.conf"/' /etc/conf.d/iptables
#sed -i.bck-$today 's/IP6TABLES_SAVE=".*"/IP6TABLES_SAVE="\/etc\/firewall\/ip6tables.conf"/' /etc/conf.d/ip6tables



# iptables
iptables -P INPUT DROP
iptables -P FORWARD DROP 
iptables -P OUTPUT ACCEPT 

iptables -F INPUT 
iptables -F FORWARD 
iptables -F OUTPUT 
iptables -t nat -F
iptables -F
iptables -X

iptables -A INPUT -p tcp -m tcp --tcp-flags FIN,SYN,RST,PSH,ACK,URG NONE -j DROP
iptables -A INPUT -p tcp -m tcp --tcp-flags FIN,SYN,RST,PSH,ACK,URG FIN,SYN,RST,PSH,ACK,URG -j DROP
iptables -A INPUT -f -j DROP
iptables -A INPUT -p tcp -m tcp ! --tcp-flags FIN,SYN,RST,ACK SYN -m conntrack --ctstate NEW -j DROP

#    10.0.0.0/8 -j (A)
#    172.16.0.0/12 (B)
#    192.168.0.0/16 (C)
#    224.0.0.0/4 (MULTICAST D)
#    240.0.0.0/5 (E)
#    127.0.0.0/8 (LOOPBACK)

# spoofing
iptables -N spoofing
iptables -A spoofing -s 192.168.0.0/16 -j DROP
iptables -A spoofing -s 172.16.0.0/12 -j DROP
#iptables -A spoofing -s 10.0.0.0/8 -j DROP
iptables -A spoofing -s 224.0.0.0/4 -j DROP
iptables -A spoofing -s 240.0.0.0/5 -j DROP
iptables -A spoofing -s 127.0.0.0/8 -j DROP
iptables -A INPUT -i eth0 -j spoofing

iptables -N icmp_chain
### ** assumed that default INPUT policy set to DROP ** #############
iptables -A icmp_chain -p icmp --icmp-type echo-reply -j ACCEPT
iptables -A icmp_chain -p icmp --icmp-type destination-unreachable -j ACCEPT
iptables -A icmp_chain -p icmp --icmp-type time-exceeded -j ACCEPT
## ** all our server to respond to pings ** ##
iptables -A icmp_chain -p icmp --icmp-type echo-request -j ACCEPT
iptables -A INPUT -p icmp -m limit --limit 1/s --limit-burst 5 -j icmp_chain

#iptables -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT

iptables -N syn_flood
iptables -A INPUT -i eth0 -p tcp --syn -j syn_flood
iptables -A syn_flood -m limit --limit 1/s --limit-burst 10 -j RETURN
iptables -A syn_flood -j LOG --log-level 7  --log-prefix "FW: syn_flood: "
iptables -A syn_flood -j DROP

iptables -A INPUT -p tcp  --dport 2200 -s 10.1.1.10  -j ACCEPT
iptables -A INPUT -i lo -j ACCEPT
iptables -P INPUT DROP

# drop all outgoing SMTP connection to preven SPAM spreading
# recommended use of SSMPT
iptables -N mail_output
iptables -A mail_output -j LOG --log-level 7 --log-prefix "FW: mail_output: "
iptables -A mail_output -j DROP

# OUTPUT tunning
iptables -P OUTPUT ACCEPT 
iptables -A OUTPUT -p tcp -m tcp --dport 25 -j mail_output

# could be usefull in case of virtual machine
iptables -t nat -A POSTROUTING -o eth0 -j MASQUERADE

# ip6tables
ip6tables -P INPUT DROP
ip6tables -P FORWARD DROP
ip6tables -P OUTPUT ACCEPT

ip6tables -F INPUT
ip6tables -F FORWARD
ip6tables -F OUTPUT

ip6tables -A INPUT -i lo -j ACCEPT

/etc/init.d/iptables save
/etc/init.d/iptables restart

/etc/init.d/ip6tables save
/etc/init.d/ip6tables restart

rc-config add iptables
rc-config add ip6tables
