#!/bin/bash

M_start='begin'
M_done='end'
M_next='next'

export script_name=$(basename $0)

function start_check()
{
  if [ -e "tmp/$script_name.$M_done" ]; then
    echo "INFO: $script_name already done"
    exit 0
  fi
}

function begin_mark()
{
  if [ -e "tmp/$script_name.$M_start" ]; then
    echo "WARNING: previous execution of $script_name does not finish successfully"
    echo "INFO: trying again ..."
    touch "tmp/$script_name.$M_next"
  else
    touch "tmp/$script_name.$M_start"
    echo "INFO: executing $script_name"
  fi
}

function done_mark()
{
  touch "tmp/$script_name.$M_done"
  sleep 1
}
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

start_check
begin_mark
