#!/bin/bash
# generate locale environment

echo "-- $0 --"

if [ ! -e /etc/locale.gen.orig ]; then
  cp /etc/locale.gen /etc/locale.gen.orig
fi

cat >/etc/locale.gen <<_EOF_
en_US.UTF-8 UTF-8
cs_CZ.UTF-8 UTF-8
_EOF_

locale-gen

cat >/etc/env.d/02locale <<_EOF_
LANG="en_US.UTF-8"
LC_COLLATE="C"
_EOF_


locale_number=$(eselect locale list | grep en_US.UTF-8 |sed -e "s/^.*\[\(.*\)\].*/\1/")
eselect locale set "$locale_number"

. /etc/profile
