#!/bin/bash
# setup postfix

echo "-- $0 --"

echo 'DEFAULT="$HOME/Maildir/inbox"' >>/etc/maildroprc

cat >>/etc/postfix/main.cf <<END_APPEND
# added by installation
home_mailbox = ~/Maildir/inbox/
inet_interfaces = localhost
mydomain = ${DOMAIN}
myhostname = ${HOSTNAME}.${DOMAIN}
mydestination = \$myhostname, localhost.\$mydomain, localhost
mailbox_command = /usr/bin/maildrop
END_APPEND

echo "root:               ${FIRST_USER}" >>/etc/mail/aliases
newaliases

if [ "${SYSTEMD}" = "0" ] ; then
  /etc/init.d/postfix restart
  rc-config add postfix
else
  systemctl enable postfix
  systemctl restart postfix
fi

mkdir -m 0700 /etc/skel/Maildir
maildirmake /etc/skel/Maildir/inbox
