#!/bin/bash

M_start='begin'
M_done='end'
M_next='next'

script_name=$(basename "$0")

function start_check {
  script_name=$1
  if [ -e "tmp/$script_name.$M_done" ]; then
    echo "INFO: $script_name already done"
    return 0
  else
    echo "INFO: $script_name not done!"
    return 1
  fi
}

function begin_mark {
  script_name=$1
  if [ -e "tmp/$script_name.$M_start" ]; then
    echo "WARNING: previous execution of $script_name does not finish successfully"
    echo "INFO: trying again ..."
    touch "tmp/$script_name.$M_next"
  else
    touch "tmp/$script_name.$M_start"
    echo "INFO: executing $script_name"
  fi
}

function done_mark {
  script_name=$1
  touch "tmp/$script_name.$M_done"
  sleep 1
}

function mark_fail()
{
   item=$1
   echo "ERROR: during execution (script/$item)"
   touch "tmp/$item.err"
   exit 1
}

function time_duration(){
  tmp_location="/var/tmp/gen2/tmp"
  first_file=$(ls -t ${tmp_location}/* | tail -1)
  last_file=$(ls -rt ${tmp_location}/* | tail -1)

  time_start=$(stat --format="%Y" $first_file)
  time_stop=$(stat --format="%Y" $last_file)
  time_diff=$(($time_stop - $time_start))

  echo "+----------------------------------------------+"
  echo "| Time summary                                 |"
  echo "+----------------------------------------------+"
#  echo "| Start of installation: " $(date -d @${time_start} +"%Y-%m-%d %H:%M:%S") " |"
#  echo "| End of installation: " $(date -d @${time_stop} +"%Y-%m-%d %H:%M:%S") "   |"
  printf "| Start of installation:  %s %s  |\n" $(date -d @${time_start} +"%Y-%m-%d %H:%M:%S")
  printf "| End of installation:  %s %s    |\n" $(date -d @${time_stop} +"%Y-%m-%d %H:%M:%S")
  echo "+----------------------------------------------+"
#  echo "| Duration: " $(date -u -d @${time_diff} +"%T") "                         |"
  printf "| Duration:  %-32s  |\n" $(date -u -d @${time_diff} +"%T")
  echo "+----------------------------------------------+"

}


#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

#start_check 
#begin_mark
