#!/bin/bash

. /etc/profile

echo "-- $0 --"
export DONT_MOUNT_BOOT=1
export GRUB_ALT_INSTALLDIR=/boot
# grub
[ -d /etc/portage/package.mask ] || mkdir /etc/portage/package.mask
echo ">=sys-boot/grub-2.00" >/etc/portage/package.mask/grub
[ -d /etc/portage/package.use ] || mkdir /etc/portage/package.use
echo "sys-boot/grub -ncurses" >/etc/portage/package.use/grub
time emerge grub

echo "grub installation"
emerge --config =grub-0.97-r18

# grub install
cat /proc/mounts

grub-install --no-floppy "${ROOTDISK}"

cp /boot/grub/grub.conf /boot/grub/grub.conf.bck
cat <<_EOF_ >/boot/grub/grub.conf
serial --unit=0 --speed=115200 --word=8 --parity=no --stop=1
terminal --timeout=15 serial console

default 0
timeout 5
#splashimage=(hd0,0)/boot/grub/splash.xpm.gz

_EOF_
