#!/bin/bash

. /etc/profile

# Automatic to get first ethernet interface (new naming)
if [ -z ${NETDEV} ];
then
  NETDEV=$(ls /proc/sys/net/ipv4/conf | awk '/^en/ {print $1; exit}')
fi

# networking
if [ "${SYSTEMD}" = "0" ]; then
  pushd .
  cd /etc/init.d || exit 1
  ln -s net.lo "net.${NETDEV:=eth0}"
  rc-update add "net.${NETDEV}" default
  popd
fi

time emerge dhcpcd

if [ "${SYSTEMD}" = "1" ]; then
  # enable service
ln -s /lib/systemd/system/dhcpcd.service \
      /etc/systemd/system/multi-user.target.wants/dhcpcd.service
fi
