#!/bin/bash

declare -i error=0

set +e
if [ "${KERNEL:-}" != "genkernel" ]; then
  echo "INFO: precheck kernel config - genkernel"
  if [ ! -e "clients/${CLIENT}/${KERNEL}" ]; then
    echo "ERROR: precheck kernel config location failed"
    echo "ERROR:   (clients/${CLIENT}/${KERNEL})"
    error=$((error+1))
  fi
fi

if [ ! -e "data/${STORAGE}" ]; then
  echo "ERROR: precheck storage config location failed"
  echo "ERROR:   (data/${STORAGE})"
  error=$((error+1))
fi

if [ ! -e "clients/${CLIENT}/world" ]; then
  echo "ERROR: precheck world file location failed"
  echo "ERROR:   (clients/${CLIENT}/world)"
  error=$((error+1))
fi
set -e

# finnal result
if [ $error -gt 0 ]; then
  echo "ERROR: cannot continue wrong configuration"
  exit 1
else
  exit 0
fi
