#!/bin/bash
# prepare final execution

if [ "${SYSTEMD}" = "1" ] ; then
  # systemd init
  cat >/etc/systemd/system/gen2-start.service <<_EOF_
# /etc/systemd/system/gen2-start.service
[Unit]
Description=Start aicontrol for gen2install after restart
After=network.target

[Service]
Type=oneshot
RemainAfterExit=yes
WorkingDirectory=/var/tmp/gen2
ExecStart=/var/tmp/gen2/aicontrol.sh $CLIENT

[Install]
WantedBy=multi-user.target
_EOF_

  # enable service
  ln -s /etc/systemd/system/gen2-start.service \
        /etc/systemd/system/multi-user.target.wants/gen2-start.service

else

  [ -d "/etc/local.d" ] || mkdir  "/etc/local.d"

  cat <<_EOF_ >/etc/local.d/gen2.start
#!/bin/bash

cd /var/tmp/gen2
bash aicontrol.sh $CLIENT &

_EOF_

  chmod +x /etc/local.d/gen2.start

fi
