#!/bin/bash

# clean partition table first
#dd if=/dev/zero of="${ROOTDISK}" bs=512 count=1
dd if=/dev/zero of="${ROOTDISK}" bs=1MiB count=2 
# put new partition table
cat "data/${STORAGE}" |sfdisk -f "${ROOTDISK}"
# mark bootable disk
sfdisk -A "${ROOTDISK}" 1

# create filesystem and mount
if [ ! -d /mnt/gentoo ]; then
  mkdir /mnt/gentoo
fi

# reiserfs
if [ "$FSTYPE" = "reiserfs" ]; then
mkfs.reiserfs -q "${ROOTDISK}"1
mount -o noatime,nodiratime,notail "${ROOTDISK}"1 /mnt/gentoo

# ext4
elif [ "$FSTYPE" = "ext4" ]; then
mkfs.ext4 -q "${ROOTDISK}"1
mount "${ROOTDISK}"1 /mnt/gentoo

fi

# swap partition
mkswap "${ROOTDISK}"2 && swapon "${ROOTDISK}"2
