
date_stamp=$(date +%Y%m%d)

cd /usr/src/linux || exit 1

if ! [ -e .config ]; then
  echo "config file is not in place"
  exit 1
fi

if [ -z $ARCH ]; then
  ARCH="x86"
fi

if [ -z "$ROOTDISK" ]; then
  ROOTDISK="/dev/sda"
fi

kversion=$(awk '/Kernel Configuration/ {print $3}' .config)


if make -j2 && make modules_install;
then
  cp "arch/${ARCH}/boot/bzImage" "/boot/kernel-$kversion-$date_stamp"
  cp ".config /boot/config-$kversion-$date_stamp"
  cp System.map "/boot/System.map-$kversion-$date_stamp"
  rm /boot/System.map 
  pushd .
  cd /boot || exit 1
  ln -s "System.map-$kversion-$date_stamp" System.map
  popd
else
  echo "ERROR: problem with compilation!"
  exit 1
fi

# kernel_opt=""
# grub_file="/boot/grub/menu.lst"
# kernel_opt="$kernel_opt root=${ROOTDISK}1"
# kernel_opt="$kernel_opt net.ifnames=0"
# kernel_opt="$kernel_opt raid=noautodetect"
# kernel_opt="$kernel_opt console=tty0 console=ttyS0,115200n8"
# echo "#--------------------------------------------" >>"$grub_file"
# echo "title Gentoo Linux - compile date $date_stamp" >>"$grub_file"
# echo "root (hd0,0)"                                  >>"$grub_file"
# echo "kernel /boot/bzImage-$date_stamp $kernel_opt"  >>"$grub_file"

emerge @module-rebuild

echo "---------------"
echo "Make it default"
#echo "vim $grub_file "
echo "---------------"
