#!/usr/bin/perl -w

use strict;
use warnings;
use Expect;

my $command = 'telnet localhost 4444';
my @parameters = ();

my $exp = new Expect;
$exp->raw_pty(1);
$exp->spawn($command, @parameters)
  or die "Cannot spawn $command: $!\n";

sleep 3;            # give it time to prepare grub
$exp->send("\n");   # send some string there:
sleep 3;            # give it time to prepare grub
$exp->send("\n");   # send some string there:

$exp->expect(5, ['livecd login:']);
$exp->send("root\n");
$exp->expect(5, ['Password:']);
$exp->send("inttest\n");
# login done prepare ssh service
my @cmd_list = (
  "dhcpcd eth0",
  "/etc/init.d/sshd start",
  "/etc/init.d/network restart",
  "sed -i.back  's/^.*PermitRootLogin.*\$/PermitRootLogin yes/' /etc/ssh/sshd_config",
  "/etc/init.d/sshd restart",
  "route add default gw 10.0.2.2"
);
foreach my $cmd (@cmd_list){
#  print "cmd - $cmd\n";
  $exp->send("$cmd\n");
  sleep 1;
}
$exp->send("logout\n");
$exp->soft_close();

