#!/usr/bin/perl -w

use strict;
use warnings;
use Expect;

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
my ($scp, $cmd, $location, $parameters, $exp, $script_path) = ();
my @parameters = ();
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

print "Preparing ssh via telnet\n";
$cmd = 'telnet localhost 4444';
@parameters = ();

$exp = new Expect;
$exp->raw_pty(1);
$exp->spawn($cmd, @parameters)
  or die "Cannot spawn $cmd: $!\n";

sleep 3;            # give it time to prepare grub
$exp->send("\n");   # send some string there:
sleep 3;            # give it time to prepare grub
$exp->send("\n");   # send some string there:

$exp->expect(5, ['livecd login:']);
$exp->send("root\n");
$exp->expect(5, ['Password:']);
$exp->send("inttest\n");
# login done prepare ssh service
my @cmd_list = (
  "dhcpcd eth0",
  "/etc/init.d/sshd start",
  "/etc/init.d/network restart",
  "sed -i.back  's/^.*PermitRootLogin.*\$/PermitRootLogin yes/' /etc/ssh/sshd_config",
  "/etc/init.d/sshd restart",
  "route add default gw 10.0.2.2"
);
foreach my $cmd (@cmd_list){
#  print "cmd - $cmd\n";
  $exp->send("$cmd\n");
  sleep 1;
}
$exp->send("logout\n");
$exp->soft_close();
print "Preparing ssh via telnet - DONE\n";

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

print "Uploading files\n";
$scp = 'scp  -P 5555 -r -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no ';
$location = '/home/pforty/work/gentoo-install root@localhost:/tmp';
$cmd = $scp.$location;
@parameters = ();

$exp = new Expect;
$exp->raw_pty(1);
$exp->spawn($cmd, @parameters)
  or die "Cannot spawn $cmd: $!\n";
$exp->expect(20, ['Password:']);
$exp->send("inttest\n");
sleep 1;
print "Uploading files - DONE\n";

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

print "Phase 0\n";
$cmd = 'ssh -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no  localhost -p 5555 -l root';
@parameters = ();

$exp = new Expect;
$exp->raw_pty(1);
$exp->spawn($cmd, @parameters)
  or die "Cannot spawn $cmd: $!\n";

$exp->expect(20, ['Password:']);
$exp->send("inttest\n");
sleep 1;

my @script_list = ();

push @script_list, 'cd /tmp/gentoo-install';
push @script_list, 'storage.sh';
push @script_list, 'download.sh';
push @script_list, 'mount_chroot.sh';
push @script_list, 'copy_to_new.sh';

$script_path = '/tmp/gentoo-install/tmp';
foreach my $item (@script_list){
  $exp->send("bash $script_path/$item\n");
  sleep 1;
}

$exp->send('chroot /mnt/gentoo /bin/bash\n');
sleep 1;
$exp->send('env-update && source /etc/profile\n');
sleep 1;


push @script_list, 'portage_basic.sh';
push @script_list, 'kernel.sh';
push @script_list, 'grub.sh';
push @script_list, 'passwd-root.sh';
push @script_list, 'network-basic.sh';
push @script_list, 'fstab.sh';
push @script_list, 'packages-minimal.sh';
push @script_list, 'ssh.sh';
push @script_list, 'cleaning.sh';
$script_path = '/gentoo-install/scripts';
foreach my $item (@script_list){
  $exp->send("bash $script_path/$item\n");
  sleep 1;
}

$exp->send("exit\n");
sleep 1;
$exp->send("bash $script_path/umount_chroot.sh\n");
sleep 1;
$exp->send("poweroff\n");
sleep 1;

$exp->send("logout\n");
sleep 1;
$exp->soft_close();
print "Phase 0 - DONE\n";

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
