#!/bin/bash

mem='1G'
hdd_size='12G'

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

usage()
{
  echo "Usage:"
  echo "  $0 create <name>"
  echo "  $0 install <name>"
  echo "  $0 start <name>"
  echo "  $0 status <name>|all"
  echo "  $0 delete <name>"
  exit 1
}

#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

if [ $# -ne 2 ]; then
  usage
fi

operation=$1
vname=$2

if [ -z $operation ]; then
  usage
fi
if [ -z $vname ]; then
  usage
fi

img_dir='/home/pforty/vmachines'
img_name="$img_dir/$vname.qcow2"
log_name="$img_dir/$vname.log"
iso_dir='/home/pforty/iso'
iso_name="$iso_dir/install-amd64-minimal-20160901.iso"
timestamp=$(date "+%Y%m%d_%H%M%S")
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

create_image_qcow2()
{
  if [ -e $log_name ];then
    echo "Logfile detected - $log_name"
    echo "skipping ..."
    exit 1
  fi
# QEMU pre-setup
  qemu-img create -f qcow2 $img_name $hdd_size
  echo "Create time - $timestamp" >$log_name
  qemu-img info $img_name >>$log_name
}

create_image_lvm()
{
  vg_name="IDESSD"
  if [ -e $log_name ];then
    echo "Logfile detected - $log_name"
    echo "skipping ..."
    exit 1
  fi
  lvcreate --size $hdd_size --name $vname  $vg_name
  echo "Create time - $timestamp" >$log_name
}



boot_cd()
{
  qemu-system-x86_64 -enable-kvm -m $mem -boot d -cdrom $iso_name -hda $img_name \
    -net nic -net user,hostfwd=tcp::5555-:22 \
    -serial telnet:127.0.0.1:4444,server,nowait
#    -nographic \
#    -vnc unix:vnc_test.socket
  echo "Installation time - $timestamp" >>$log_name
}

boot_net()
{
  img_name="/dev/IDESSD/gentoo64"
  qemu-system-x86_64 -enable-kvm -m $mem -boot order=cn \
    -smp 2 \
    -drive file=$img_name,index=0,media=disk,format=raw \
    -netdev tap,id=qnet0,ifname=tapUp,script=no,downscript=no \
    -device virtio-net-pci,netdev=qnet0,id=nic0,mac='52:54:11:11:11:00'
#    -device e1000,netdev=qnet0,id=nic0,mac='52:54:11:22:33:44'
  echo "Installation time - $timestamp" >>$log_name
}

boot_netx()
{
  qemu-system-x86_64 -enable-kvm -m $mem -boot n -hda $img_name \
    -net nic -net user,hostfwd=tcp::5555-:22 \
    -serial telnet:127.0.0.1:4444,server,nowait
#    -nographic \
#    -vnc unix:vnc_test.socket
  echo "Installation time - $timestamp" >>$log_name
}

# old 
boot_hdd1()
{
  qemu-system-x86_64 -enable-kvm \
    -m $mem \
    -boot c \
    -hda $img_name \
    -net nic -net user,hostfwd=tcp::5555-:22,smb=/tmp/share \
    -serial telnet:127.0.0.1:4444,server
  echo "Start time - $timestamp" >>$log_name
}

boot_hdd()
{
  qemu-system-x86_64 -enable-kvm \
    -m $mem \
    -kernel /home/tftproot/gentoo.64 -initrd /home/tftproot/initramfs.install64.gz -append 'root=/dev/ram0 init=/linuxrc loop=/image.squashfs looptype=squashfs cdroot=1 real_root=/dev/sda raid=noautodetect ip=dhcp net.ifnames=0 CLIENT=qemu' \
    -boot c \
    -hda $img_name \
    -net nic -net user,hostfwd=tcp::5555-:22,smb=/tmp/share \
#    -serial telnet:127.0.0.1:4444,server
  echo "Start time - $timestamp" >>$log_name
}

show_status()
{
  if [ "$vname" == "all" ]; then
    for item in $(ls $img_dir/*.qcow2); do
      vname=$(basename $item)
      echo "vmachine - ${vname%%.qcow2}"
    done
    exit 0
  fi
  cat $log_name
}

delete_hdd()
{
  if [ -e $img_name ]; then rm -f $img_name && echo "  image for $vname"
  else echo "Image does not exists - $img_name"
  fi 
  if [ -e $log_name ]; then rm -f $log_name && echo "  log for $vname"
  else echo "Log does not exists - $log_name"
  fi 
} 

case "$operation" in
'create') echo ">>Create ..."; create_image_lvm ;;
'install') echo ">>Install ..."; boot_net ;;
'start') echo ">>Start ..."; boot_hdd ;;    
'status') echo ">>Status ..."; show_status ;;
'delete') echo ">>Delete ..."; delete_hdd ;;
*) usage ;;
esac

