#!/bin/sh

IMG_FILE="$HOME/vmachines/GentooVM.img"
ISO_FILE="$HOME/iso/install-x86-minimal-20150414.iso"
export IMG_FILE ISO_FILE

if [ ! -e ${IMG_FILE} ]; then
  dd if=/dev/zero of=${IMG_FILE} bs=1M count=5000
fi

# exec qemu-system-x86_64 -enable-kvm \
#        -net nic -net user,hostname=gentoovm \
cpu_host () {
  exec qemu-system-i386 -enable-kvm \
        -cpu host \
        -drive file=${IMG_FILE},if=virtio \
        -cdrom ${ISO_FILE} \
        -netdev user,id=vmnic,hostname=gentoovm -device virtio-net,netdev=vmnic \
        -m 1024M \
        -monitor stdio \
        -name "Gentoo VM" \
        $@
}

cpu_host_tap () {
  exec qemu-system-i386 -enable-kvm \
        -boot n \
        -cpu host \
        -drive file=${IMG_FILE},if=virtio \
        -cdrom ${ISO_FILE} \
        -netdev tap,id=vmnic -device virtio-net,netdev=vmnic \
        -m 1024M \
        -monitor stdio \
        -name "Gentoo VM" \
        $@
}

cpu_host_nokvm () {
  exec qemu-system-i386 \
        -drive file=${IMG_FILE},if=virtio \
        -cdrom ${ISO_FILE} \
        -netdev user,id=vmnic,hostname=gentoovm -device virtio-net,netdev=vmnic \
        -m 1024M \
        -monitor stdio \
        -name "Gentoo VM" \
        $@
}

cpu_pentium2 () {
  exec qemu-system-i386 -enable-kvm \
        -cpu pentium2 \
        -drive file=${IMG_FILE},if=virtio \
        -cdrom ${ISO_FILE} \
        -netdev user,id=vmnic,hostname=gentoovm -device virtio-net,netdev=vmnic \
        -m 1024M \
        -monitor stdio \
        -name "Gentoo VM" \
        $@
}

#cpu_host
cpu_host_tap
#cpu_host_nokvm
#cpu_pentium2
