# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.0.0.9999
#hackport: flags: +pedantic

CABAL_FEATURES="nocabaldep"
inherit haskell-cabal git-r3

DESCRIPTION="Rebuild Haskell dependencies in Gentoo"
HOMEPAGE="https://github.com/gentoo-haskell/haskell-updater#readme"
EGIT_REPO_URI="https://github.com/gentoo-haskell/haskell-updater.git"

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS=""

# Need a lower version for portage to get --keep-going
RDEPEND="|| ( >=sys-apps/portage-2.1.6
		sys-apps/pkgcore )"
DEPEND=">=dev-lang/ghc-6.12.1"

src_prepare() {
	default

	if use prefix; then
		sed -i -e "s,/var/db/pkg,${EPREFIX}&,g" \
			"${S}/Distribution/Gentoo/Packages.hs" || die

		sed -i -e 's,"/","'"${EPREFIX}"'/",g' \
			"${S}/Distribution/Gentoo/GHC.hs" || die
	fi

	sed -e 's/^version:.*/&.9999/' -i ${PN}.cabal || die # just to distinct from release install
}

src_configure() {
	haskell-cabal_src_configure \
		--flag=pedantic \
		--bindir="${EPREFIX}/usr/sbin" \
		--constraint="Cabal == $(cabal-version)"
}

src_install() {
	cabal_src_install

	dodoc TODO
}
