# Copyright 2023-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

CRATES="
	addr2line@0.22.0
	adler2@2.0.0
	adler32@1.2.0
	adler@1.0.2
	ahash@0.7.8
	ahash@0.8.11
	aho-corasick@1.1.3
	alloc-no-stdlib@2.0.4
	alloc-stdlib@0.2.2
	alloca@0.4.0
	allocator-api2@0.2.18
	alphanumeric-sort@1.5.3
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	ansi-str@0.8.0
	ansitok@0.2.0
	anstream@0.6.15
	anstyle-parse@0.2.5
	anstyle-query@1.1.1
	anstyle-wincon@3.0.4
	anstyle@1.0.8
	anyhow@1.0.86
	arboard@3.4.0
	argminmax@0.6.2
	array-init-cursor@0.2.0
	arrayvec@0.5.2
	arrayvec@0.7.6
	assert-json-diff@2.0.2
	assert_cmd@2.0.16
	async-stream-impl@0.3.5
	async-stream@0.3.5
	async-trait@0.1.81
	atoi@2.0.0
	atoi_simd@0.15.6
	atomic-waker@1.1.2
	autocfg@1.3.0
	avro-schema@0.3.0
	backtrace-ext@0.2.1
	backtrace@0.3.73
	base64@0.21.7
	base64@0.22.1
	bindgen@0.69.4
	bit-set@0.8.0
	bit-vec@0.8.0
	bitflags@1.3.2
	bitflags@2.6.0
	bitvec@1.0.1
	block-buffer@0.10.4
	block2@0.5.1
	borsh-derive@1.5.1
	borsh@1.5.1
	bracoxide@0.1.4
	brotli-decompressor@4.0.1
	brotli@6.0.0
	bstr@1.10.0
	bumpalo@3.16.0
	byte-unit@5.1.4
	bytecheck@0.6.12
	bytecheck_derive@0.6.12
	bytecount@0.6.8
	bytemuck@1.17.0
	bytemuck_derive@1.7.1
	byteorder@1.5.0
	bytes@1.8.0
	bytesize@1.3.0
	calamine@0.24.0
	cassowary@0.3.0
	castaway@0.2.3
	cc@1.1.14
	cexpr@0.6.0
	cfg-if@1.0.0
	cfg_aliases@0.1.1
	cfg_aliases@0.2.1
	chardetng@0.1.17
	charset@0.1.5
	chrono-humanize@0.2.3
	chrono-tz-build@0.2.1
	chrono-tz-build@0.4.0
	chrono-tz@0.10.0
	chrono-tz@0.8.6
	chrono@0.4.38
	chumsky@0.9.3
	clang-sys@1.8.1
	clap@4.5.16
	clap_builder@4.5.15
	clap_derive@4.5.13
	clap_lex@0.7.2
	clipboard-win@5.4.0
	codepage@0.1.2
	colorchoice@1.0.2
	colorz@1.1.2
	comfy-table@7.1.1
	compact_str@0.7.1
	compact_str@0.8.0
	console@0.15.8
	const-random-macro@0.1.16
	const-random@0.1.18
	const_format@0.2.32
	const_format_proc_macros@0.2.32
	core-foundation-sys@0.8.7
	core-foundation@0.9.4
	cpufeatures@0.2.13
	crc-catalog@1.1.1
	crc32fast@1.4.2
	crc@2.1.0
	crossbeam-channel@0.5.13
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.11
	crossbeam-utils@0.8.20
	crossterm@0.27.0
	crossterm@0.28.1
	crossterm_winapi@0.9.1
	crunchy@0.2.2
	crypto-common@0.1.6
	cssparser-macros@0.6.1
	cssparser@0.34.0
	csv-core@0.1.11
	csv@1.3.0
	ctrlc@3.4.5
	curl-sys@0.4.74+curl-8.9.0
	curl@0.4.46
	data-encoding@2.6.0
	deranged@0.3.11
	derive-new@0.6.0
	derive_more@0.99.18
	dialoguer@0.11.0
	diff@0.1.13
	difflib@0.4.0
	digest@0.10.7
	dirs-sys@0.4.1
	dirs@5.0.1
	dlib@0.5.2
	dlv-list@0.5.2
	doc-comment@0.3.3
	doctest-file@1.0.0
	downcast-rs@1.2.1
	dtoa-short@0.3.5
	dtoa@1.0.9
	dtparse@2.0.1
	dunce@1.0.5
	dyn-clone@1.0.17
	ego-tree@0.9.0
	either@1.13.0
	eml-parser@0.1.4
	encode_unicode@0.3.6
	encoding_rs@0.8.34
	enum_dispatch@0.3.13
	env_filter@0.1.2
	env_logger@0.11.5
	env_logger@0.8.4
	equivalent@1.0.1
	erased-serde@0.4.5
	errno@0.3.9
	error-code@3.2.0
	ethnum@1.5.0
	fallible-iterator@0.3.0
	fallible-streaming-iterator@0.1.9
	fancy-regex@0.14.0
	fast-float@0.2.0
	fastrand@2.1.1
	fd-lock@4.0.2
	file-id@0.2.1
	filesize@0.2.0
	filetime@0.2.24
	fixedbitset@0.4.2
	flate2@1.0.32
	float-cmp@0.9.0
	fnv@1.0.7
	foreign-types-shared@0.1.1
	foreign-types@0.3.2
	form_urlencoded@1.2.1
	fs_extra@1.3.0
	fsevent-sys@4.1.0
	funty@2.0.0
	futf@0.1.5
	futures-channel@0.3.30
	futures-core@0.3.30
	futures-executor@0.3.30
	futures-io@0.3.30
	futures-macro@0.3.30
	futures-sink@0.3.30
	futures-task@0.3.30
	futures-util@0.3.30
	futures@0.3.30
	fuzzy-matcher@0.3.7
	fxhash@0.2.1
	generic-array@0.14.7
	gethostname@0.4.3
	getrandom@0.2.15
	gimli@0.29.0
	git2@0.19.0
	gjson@0.8.1
	glob-match@0.2.1
	glob@0.3.1
	goblin@0.7.1
	h2@0.4.6
	halfbrown@0.2.5
	hash32@0.3.1
	hashbrown@0.12.3
	hashbrown@0.14.5
	hashbrown@0.15.0
	hashlink@0.9.1
	heapless@0.8.0
	heck@0.5.0
	hermit-abi@0.3.9
	hermit-abi@0.4.0
	hex@0.4.3
	home@0.5.9
	html5ever@0.27.0
	html5ever@0.29.0
	http-body-util@0.1.2
	http-body@1.0.1
	http@1.1.0
	httparse@1.9.4
	httpdate@1.0.3
	human-date-parser@0.2.0
	humantime@2.1.0
	hyper-util@0.1.7
	hyper@1.4.1
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.60
	ical@0.11.0
	idna@0.5.0
	indexmap@2.6.0
	indicatif@0.17.8
	inotify-sys@0.1.5
	inotify@0.9.6
	instant@0.1.13
	interprocess@2.2.1
	inventory@0.3.15
	is-docker@0.2.0
	is-terminal@0.4.13
	is-wsl@0.4.0
	is_ci@1.2.0
	is_debug@1.0.1
	is_executable@1.0.1
	is_terminal_polyfill@1.70.1
	itertools@0.11.0
	itertools@0.12.1
	itertools@0.13.0
	itoa@1.0.11
	itoap@1.0.1
	jobserver@0.1.32
	joinery@2.1.0
	js-sys@0.3.70
	jsonpath_lib_polars_vendor@0.0.1
	kqueue-sys@1.0.4
	kqueue@1.0.8
	lazy_static@1.5.0
	lazycell@1.3.0
	lexical-core@0.8.5
	lexical-parse-float@0.8.5
	lexical-parse-integer@0.8.6
	lexical-util@0.8.5
	lexical-write-float@0.8.5
	lexical-write-integer@0.8.5
	libc@0.2.158
	libflate@1.4.0
	libflate_lz77@1.2.0
	libgit2-sys@0.17.0+1.8.1
	libloading@0.8.5
	libm@0.2.8
	libmimalloc-sys@0.1.39
	libproc@0.14.8
	libredox@0.1.3
	libsqlite3-sys@0.28.0
	libssh2-sys@0.3.0
	libz-sys@1.1.19
	linked-hash-map@0.5.6
	linux-raw-sys@0.4.14
	lock_api@0.4.12
	log@0.4.22
	lru@0.12.4
	lscolors@0.17.0
	lsp-server@0.7.6
	lsp-types@0.95.1
	lz4-sys@1.10.0
	lz4@1.26.0
	mac@0.1.1
	mach2@0.4.2
	markup5ever@0.12.1
	markup5ever@0.14.0
	markup5ever_rcdom@0.3.0
	md-5@0.10.6
	memchr@2.7.4
	memmap2@0.7.1
	miette-derive@7.2.0
	miette@7.2.0
	mimalloc@0.1.43
	mime@0.3.17
	mime_guess@2.0.5
	minimal-lexical@0.2.1
	miniz_oxide@0.7.4
	miniz_oxide@0.8.0
	mio@0.8.11
	mio@1.0.2
	mockito@1.5.0
	multipart-rs@0.1.11
	multiversion-macros@0.7.4
	multiversion@0.7.4
	native-tls@0.2.12
	new_debug_unreachable@1.0.6
	nix@0.28.0
	nix@0.29.0
	nom@7.1.3
	notify-debouncer-full@0.3.2
	notify@6.1.1
	now@0.1.3
	ntapi@0.4.1
	nu-ansi-term@0.50.1
	num-bigint@0.4.6
	num-complex@0.4.6
	num-conv@0.1.0
	num-format@0.4.4
	num-integer@0.1.46
	num-iter@0.1.45
	num-rational@0.4.2
	num-traits@0.2.19
	num@0.4.3
	num_threads@0.1.7
	number_prefix@0.4.0
	objc-sys@0.3.5
	objc2-app-kit@0.2.2
	objc2-core-data@0.2.2
	objc2-core-image@0.2.2
	objc2-encode@4.0.3
	objc2-foundation@0.2.2
	objc2-metal@0.2.2
	objc2-quartz-core@0.2.2
	objc2@0.5.2
	object@0.36.3
	oem_cp@2.0.0
	omnipath@0.1.6
	once_cell@1.20.1
	open@5.3.0
	openssl-macros@0.1.1
	openssl-probe@0.1.5
	openssl-src@300.3.1+3.3.1
	openssl-sys@0.9.103
	openssl@0.10.66
	option-ext@0.2.0
	ordered-multimap@0.7.3
	os_display@0.1.3
	os_pipe@1.2.1
	owo-colors@4.0.0
	papergrid@0.12.0
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	parquet-format-safe@0.2.4
	parse-zoneinfo@0.3.1
	paste@1.0.15
	pathdiff@0.2.1
	percent-encoding@2.3.1
	peresil@0.3.0
	pest@2.7.11
	pest_derive@2.7.11
	pest_generator@2.7.11
	pest_meta@2.7.11
	petgraph@0.6.5
	phf@0.11.2
	phf_codegen@0.11.2
	phf_generator@0.10.0
	phf_generator@0.11.2
	phf_macros@0.11.2
	phf_shared@0.10.0
	phf_shared@0.11.2
	pin-project-lite@0.2.14
	pin-utils@0.1.0
	pkg-config@0.3.30
	plain@0.2.3
	planus@0.3.1
	platform-info@2.0.3
	plist@1.7.0
	polars-arrow-format@0.1.0
	polars-arrow@0.43.1
	polars-compute@0.43.1
	polars-core@0.43.1
	polars-error@0.43.1
	polars-expr@0.43.1
	polars-io@0.43.1
	polars-json@0.43.1
	polars-lazy@0.43.1
	polars-mem-engine@0.43.1
	polars-ops@0.43.1
	polars-parquet@0.43.1
	polars-pipe@0.43.1
	polars-plan@0.43.1
	polars-row@0.43.1
	polars-schema@0.43.1
	polars-sql@0.43.1
	polars-time@0.43.1
	polars-utils@0.43.1
	polars@0.43.1
	pori@0.0.0
	portable-atomic@1.7.0
	powerfmt@0.2.0
	ppv-lite86@0.2.20
	precomputed-hash@0.1.1
	predicates-core@1.0.8
	predicates-tree@1.0.11
	predicates@3.1.2
	pretty_assertions@1.4.0
	print-positions@0.6.1
	proc-macro-crate@3.1.0
	proc-macro-error-attr@1.0.4
	proc-macro-error@1.0.4
	proc-macro2@1.0.86
	procfs-core@0.16.0
	procfs@0.16.0
	psm@0.1.21
	ptr_meta@0.1.4
	ptr_meta_derive@0.1.4
	pure-rust-locales@0.8.1
	pwd@1.4.0
	quick-error@1.2.3
	quick-error@2.0.1
	quick-xml@0.31.0
	quick-xml@0.32.0
	quick-xml@0.34.0
	quickcheck@1.0.3
	quickcheck_macros@1.0.0
	quote@1.0.37
	quoted_printable@0.5.1
	radium@0.7.0
	rand@0.8.5
	rand_chacha@0.3.1
	rand_core@0.6.4
	rand_distr@0.4.3
	ratatui@0.26.3
	raw-cpuid@11.1.0
	rayon-core@1.12.1
	rayon@1.10.0
	recursive-proc-macro-impl@0.1.1
	recursive@0.1.1
	recvmsg@1.0.0
	redox_syscall@0.5.3
	redox_users@0.4.6
	reedline@0.37.0
	ref-cast-impl@1.0.23
	ref-cast@1.0.23
	regex-automata@0.4.7
	regex-syntax@0.8.4
	regex@1.10.6
	relative-path@1.9.3
	rend@0.4.2
	rfc2047-decoder@1.0.5
	rkyv@0.7.45
	rkyv_derive@0.7.45
	rle-decode-fast@1.0.3
	rmp-serde@1.3.0
	rmp@0.8.14
	ropey@1.6.1
	roxmltree@0.19.0
	rstest@0.18.2
	rstest_macros@0.18.2
	rusqlite@0.31.0
	rust-embed-impl@8.5.0
	rust-embed-utils@8.5.0
	rust-embed@8.5.0
	rust-ini@0.21.1
	rust_decimal@1.36.0
	rustc-demangle@0.1.24
	rustc-hash@1.1.0
	rustc_version@0.4.0
	rustix@0.38.37
	rustversion@1.0.17
	ryu@1.0.18
	same-file@1.0.6
	scc@2.1.16
	schannel@0.1.23
	scoped-tls@1.0.1
	scopeguard@1.2.0
	scraper@0.21.0
	scroll@0.11.0
	scroll_derive@0.11.1
	sdd@3.0.2
	seahash@4.1.0
	security-framework-sys@2.11.1
	security-framework@2.11.1
	selectors@0.26.0
	semver@1.0.23
	serde@1.0.208
	serde_derive@1.0.208
	serde_json@1.0.127
	serde_repr@0.1.19
	serde_spanned@0.6.7
	serde_urlencoded@0.7.1
	serde_yaml@0.9.34+deprecated
	serial_test@3.1.1
	serial_test_derive@3.1.1
	servo_arc@0.4.0
	sha2@0.10.8
	shadow-rs@0.35.0
	shell-words@1.1.0
	shlex@1.3.0
	signal-hook-mio@0.2.4
	signal-hook-registry@1.4.2
	signal-hook@0.3.17
	simd-json@0.13.10
	simdutf8@0.1.4
	similar@2.6.0
	simplelog@0.12.2
	siphasher@0.3.11
	slab@0.4.9
	smallvec@1.13.2
	smawk@0.3.2
	snap@1.1.1
	socket2@0.5.7
	sqlparser@0.49.0
	stability@0.2.1
	stable_deref_trait@1.2.0
	stacker@0.1.16
	static_assertions@1.1.0
	str_indices@0.4.3
	streaming-decompression@0.1.2
	streaming-iterator@0.1.9
	strength_reduce@0.2.4
	string_cache@0.8.7
	string_cache_codegen@0.5.2
	strip-ansi-escapes@0.2.0
	strsim@0.11.1
	strum@0.26.3
	strum_macros@0.26.4
	supports-color@2.1.0
	supports-color@3.0.0
	supports-hyperlinks@3.0.0
	supports-unicode@3.0.0
	sxd-document@0.3.2
	sxd-xpath@0.4.2
	syn@1.0.109
	syn@2.0.75
	syn_derive@0.1.8
	sys-locale@0.3.1
	sysinfo@0.31.4
	sysinfo@0.32.0
	tabled@0.16.0
	tango-bench@0.6.0
	tap@1.0.1
	target-features@0.1.6
	tempfile@3.13.0
	tendril@0.4.3
	termcolor@1.4.1
	terminal_size@0.3.0
	termtree@0.4.1
	textwrap@0.16.1
	thiserror-impl@1.0.63
	thiserror@1.0.63
	thread_local@1.1.8
	time-core@0.1.2
	time-macros@0.2.18
	time@0.3.36
	tiny-keccak@2.0.2
	tinyvec@1.8.0
	tinyvec_macros@0.1.1
	titlecase@2.2.1
	tokio-util@0.7.11
	tokio@1.39.3
	toml@0.7.8
	toml@0.8.19
	toml_datetime@0.6.8
	toml_edit@0.19.15
	toml_edit@0.21.1
	toml_edit@0.22.20
	tracing-core@0.1.32
	tracing@0.1.40
	trash@5.2.0
	tree_magic_mini@3.1.5
	trim-in-place@0.1.7
	typed-arena@1.7.0
	typeid@1.0.2
	typenum@1.17.0
	typetag-impl@0.2.18
	typetag@0.2.18
	ucd-trie@0.1.6
	umask@2.1.0
	unicase@2.8.0
	unicode-bidi@0.3.15
	unicode-ident@1.0.12
	unicode-linebreak@0.1.5
	unicode-normalization@0.1.23
	unicode-reverse@1.0.9
	unicode-segmentation@1.12.0
	unicode-truncate@1.1.0
	unicode-width@0.1.11
	unicode-xid@0.2.5
	unsafe-libyaml@0.2.11
	ureq@2.10.1
	url@2.5.2
	urlencoding@2.1.3
	utf-8@0.7.6
	utf8-width@0.1.7
	utf8parse@0.2.2
	uu_cp@0.0.27
	uu_mkdir@0.0.27
	uu_mktemp@0.0.27
	uu_mv@0.0.27
	uu_uname@0.0.27
	uu_whoami@0.0.27
	uucore@0.0.27
	uucore_procs@0.0.27
	uuhelp_parser@0.0.27
	uuid@1.11.0
	v_htmlescape@0.15.8
	value-trait@0.8.1
	vcpkg@0.2.15
	version_check@0.9.5
	vte@0.10.1
	vte@0.11.1
	vte_generate_state_changes@0.1.2
	wait-timeout@0.2.0
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.93
	wasm-bindgen-macro-support@0.2.93
	wasm-bindgen-macro@0.2.93
	wasm-bindgen-shared@0.2.93
	wasm-bindgen@0.2.93
	wax@0.6.0
	wayland-backend@0.3.6
	wayland-client@0.31.5
	wayland-protocols-wlr@0.2.0
	wayland-protocols@0.31.2
	wayland-scanner@0.31.4
	wayland-sys@0.31.4
	webpage@2.0.1
	which@6.0.3
	widestring@1.1.0
	wild@2.2.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-core@0.56.0
	windows-implement@0.56.0
	windows-interface@0.56.0
	windows-result@0.1.2
	windows-sys@0.36.1
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows@0.56.0
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.36.1
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.36.1
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.36.1
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.36.1
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.36.1
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.5.40
	winnow@0.6.18
	winreg@0.52.0
	winresource@0.1.17
	winsafe@0.0.19
	wl-clipboard-rs@0.8.1
	wyz@0.5.1
	x11rb-protocol@0.13.1
	x11rb@0.13.1
	xattr@1.3.1
	xml5ever@0.18.1
	xxhash-rust@0.8.12
	yansi@0.5.1
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
	zip@0.6.6
	zstd-safe@7.2.1
	zstd-sys@2.0.13+zstd.1.5.6
	zstd@0.13.2
"

RUST_MIN_VER="1.80.1"

inherit cargo

DESCRIPTION="A new type of shell, written in Rust"
HOMEPAGE="https://www.nushell.sh"
SRC_URI="
	https://github.com/nushell/${PN}/archive/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	0BSD Apache-2.0 BSD Boost-1.0 CC-PD CC0-1.0 ISC MIT MPL-2.0 MPL-2.0
	Unicode-DFS-2016 ZLIB
"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv"
IUSE="plugins system-clipboard X"

DEPEND="
	>=dev-libs/libgit2-0.99:=
	dev-libs/oniguruma:=
	dev-libs/openssl:0=
	net-libs/libssh2:=
	net-libs/nghttp2:=
	net-misc/curl
	dev-db/sqlite:3=
	system-clipboard? (
		X? (
			x11-libs/libX11
			x11-libs/libxcb
		)
	)
"
RDEPEND="${DEPEND}"
BDEPEND="
	virtual/pkgconfig
"

RESTRICT+=" test"

QA_FLAGS_IGNORED="usr/bin/nu.*"

src_prepare() {
	use plugins || eapply "${FILESDIR/${PN}-dont-build-plugins.patch}"
	default
}

src_configure() {
	# high magic to allow system-libs
	export OPENSSL_NO_VENDOR=true
	export RUSTONIG_SYSTEM_LIBONIG=1
	export LIBGIT2_SYS_USE_PKG_CONFIG=1
	export LIBSSH2_SYS_USE_PKG_CONFIG=1
	export PKG_CONFIG_ALLOW_CROSS=1

	local myfeatures=(
	$(usev system-clipboard)
	)

	cargo_src_configure
}

src_compile() {
	cargo_src_compile --workspace
}

src_install() {
	cargo_src_install
	if use plugins ; then
		# Clear features to compile plugins
		local myfeatures=()
		cargo_src_configure
		
		cargo_src_install --path crates/nu_plugin_custom_values
		cargo_src_install --path crates/nu_plugin_example
		cargo_src_install --path crates/nu_plugin_formats
		cargo_src_install --path crates/nu_plugin_gstat
		cargo_src_install --path crates/nu_plugin_inc
		cargo_src_install --path crates/nu_plugin_polars
		cargo_src_install --path crates/nu_plugin_query
		cargo_src_install --path crates/nu_plugin_stress_internals
	fi
	local DOCS=( README.md )
	einstalldocs
}

pkg_postinst() {
	if use plugins ; then
		einfo "The plugins are installed alongside the main 'nu' binary."
		einfo "Visit https://www.nushell.sh/book/plugins.html#adding-a-plugin"
		einfo "for more information on how to use plugins."
	fi
}
