# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{10..12} )
DOCS_BUILDER="sphinx"
DOCS_DEPEND="dev-python/myst-parser"
DOCS_DIR="docs"
DISTUTILS_EXT=1
DISTUTILS_USE_PEP517=meson-python

inherit distutils-r1 docs pypi

DESCRIPTION="Python bindings for media-libs/rtmidi implemented using Cython"
HOMEPAGE="
	https://pypi.org/project/python-rtmidi/
	https://spotlightkid.github.io/python-rtmidi/
"

LICENSE="MIT"
SLOT="0"
KEYWORDS="amd64"
IUSE="+alsa jack"

# Most of these tests do not play nicely with the sandbox, some only
# work with exactly the same version of rtmidi as the bundled one, and
# several fail even with disabled sandbox unless there are actual MIDI
# I/O devices present.
RESTRICT="test"

DEPEND="media-libs/rtmidi[alsa?,jack?]"
RDEPEND="${DEPEND}"
BDEPEND="dev-python/cython[${PYTHON_USEDEP}]
	virtual/pkgconfig"

PATCHES=(
	"${FILESDIR}"/${PN}-1.5.1-unbundle_rtmidi.patch
)

distutils_enable_tests unittest

src_prepare() {
	distutils-r1_src_prepare

	# Just in case
	rm -r src/rtmidi || die
	rm src/_rtmidi.cpp || die

	# Needed by USE=doc because documentation generation happens in ${S}
	# but the version.py generated by Meson end up in respective ${BUILD_DIR}s.
	# The version put in ${S} should be ignored by everything except Sphinx but
	# just in case, be consistent and generate it unconditionally.
	sed -e "s|@VERSION@|${PV}|" < rtmidi/version.py.in > rtmidi/version.py || die
}

python_test() {
	cd "${T}" || die
	eunittest "${S}"/tests
}
