# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES="
	abscissa_core@0.7.0
	abscissa_derive@0.7.0
	addr2line@0.21.0
	adler@1.0.2
	aho-corasick@1.1.2
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.11
	anstyle-parse@0.2.3
	anstyle-query@1.0.2
	anstyle-wincon@3.0.2
	anstyle@1.0.5
	arc-swap@1.6.0
	arrayvec@0.7.4
	askama@0.12.1
	askama_derive@0.12.5
	askama_escape@0.10.3
	askama_parser@0.2.1
	async-compression@0.4.6
	atom_syndication@0.12.2
	auditable-extract@0.3.2
	auditable-info@0.7.0
	auditable-serde@0.6.0
	autocfg@1.1.0
	backtrace@0.3.69
	base64@0.21.7
	basic-toml@0.1.8
	binfarce@0.2.1
	bitflags@1.3.2
	bitflags@2.4.2
	block-buffer@0.10.4
	bstr@1.9.0
	btoi@0.4.3
	bumpalo@3.14.0
	bytes@1.5.0
	camino@1.1.6
	canonical-path@2.0.2
	cc@1.0.83
	cfg-if@1.0.0
	chrono@0.4.34
	clap@4.4.18
	clap_builder@4.4.18
	clap_derive@4.4.7
	clap_lex@0.6.0
	clru@0.6.1
	color-eyre@0.6.2
	colorchoice@1.0.0
	comrak@0.21.0
	core-foundation-sys@0.8.6
	core-foundation@0.9.4
	cpufeatures@0.2.12
	crc32fast@1.3.2
	crossbeam-channel@0.5.11
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.11
	crossbeam-utils@0.8.19
	crossbeam@0.8.4
	crypto-common@0.1.6
	darling@0.14.4
	darling_core@0.14.4
	darling_macro@0.14.4
	deranged@0.3.11
	derive_builder@0.12.0
	derive_builder_core@0.12.0
	derive_builder_macro@0.12.0
	deunicode@1.4.2
	digest@0.10.7
	diligent-date-parser@0.1.4
	display-error-chain@0.2.0
	dunce@1.0.4
	either@1.9.0
	encoding_rs@0.8.33
	entities@1.0.1
	equivalent@1.0.1
	errno@0.3.8
	eyre@0.6.12
	faster-hex@0.9.0
	fastrand@2.0.1
	filetime@0.2.23
	fixedbitset@0.4.2
	flate2@1.0.28
	fnv@1.0.7
	form_urlencoded@1.2.1
	fs-err@2.11.0
	futures-channel@0.3.30
	futures-core@0.3.30
	futures-io@0.3.30
	futures-sink@0.3.30
	futures-task@0.3.30
	futures-util@0.3.30
	generic-array@0.14.7
	getrandom@0.2.12
	gimli@0.28.1
	gix-actor@0.30.0
	gix-attributes@0.22.0
	gix-bitmap@0.2.10
	gix-chunk@0.4.7
	gix-command@0.3.3
	gix-commitgraph@0.24.0
	gix-config-value@0.14.4
	gix-config@0.34.0
	gix-credentials@0.24.0
	gix-date@0.8.3
	gix-diff@0.40.0
	gix-discover@0.29.0
	gix-features@0.38.0
	gix-filter@0.9.0
	gix-fs@0.10.0
	gix-glob@0.16.0
	gix-hash@0.14.1
	gix-hashtable@0.5.1
	gix-ignore@0.11.0
	gix-index@0.29.0
	gix-lock@13.0.0
	gix-macros@0.1.3
	gix-negotiate@0.12.0
	gix-object@0.41.0
	gix-odb@0.57.0
	gix-pack@0.47.0
	gix-packetline-blocking@0.17.3
	gix-packetline@0.17.3
	gix-path@0.10.5
	gix-pathspec@0.6.0
	gix-prompt@0.8.2
	gix-protocol@0.44.0
	gix-quote@0.4.10
	gix-ref@0.41.0
	gix-refspec@0.22.0
	gix-revision@0.26.0
	gix-revwalk@0.12.0
	gix-sec@0.10.4
	gix-submodule@0.8.0
	gix-tempfile@13.0.0
	gix-trace@0.1.7
	gix-transport@0.41.0
	gix-traverse@0.37.0
	gix-url@0.27.0
	gix-utils@0.1.9
	gix-validate@0.8.3
	gix-worktree-state@0.7.0
	gix-worktree@0.30.0
	gix@0.58.0
	gumdrop@0.8.1
	gumdrop_derive@0.8.1
	h2@0.3.24
	hashbrown@0.14.3
	heck@0.4.1
	hermit-abi@0.3.4
	home@0.5.9
	http-body@0.4.6
	http@0.2.11
	httparse@1.8.0
	httpdate@1.0.3
	humansize@2.1.3
	hyper-rustls@0.24.2
	hyper@0.14.28
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.60
	ident_case@1.0.1
	idna@0.5.0
	indenter@0.3.3
	indexmap@2.2.2
	io-close@0.3.7
	ipnet@2.9.0
	is-terminal@0.4.12
	itoa@1.0.10
	js-sys@0.3.67
	jwalk@0.8.1
	kstring@2.0.0
	lazy_static@1.4.0
	libc@0.2.153
	libm@0.2.8
	linux-raw-sys@0.4.13
	lock_api@0.4.11
	log@0.4.20
	matchers@0.1.0
	maybe-async@0.2.9
	memchr@2.7.1
	memmap2@0.9.4
	mime@0.3.17
	mime_guess@2.0.4
	minimal-lexical@0.2.1
	miniz_oxide@0.6.2
	miniz_oxide@0.7.1
	mio@0.8.10
	never@0.1.0
	nom@7.1.3
	nu-ansi-term@0.46.0
	num-conv@0.1.0
	num-traits@0.2.17
	num_cpus@1.16.0
	num_threads@0.1.6
	object@0.32.2
	once_cell@1.19.0
	openssl-probe@0.1.5
	overload@0.1.1
	owo-colors@3.5.0
	parking_lot@0.12.1
	parking_lot_core@0.9.9
	percent-encoding@2.3.1
	petgraph@0.6.4
	pin-project-lite@0.2.13
	pin-utils@0.1.0
	powerfmt@0.2.0
	proc-macro2@1.0.78
	prodash@28.0.0
	quick-xml@0.30.0
	quote@1.0.35
	rayon-core@1.12.1
	rayon@1.8.1
	redox_syscall@0.4.1
	regex-automata@0.1.10
	regex-automata@0.4.5
	regex-syntax@0.6.29
	regex-syntax@0.8.2
	regex@1.10.3
	reqwest@0.11.24
	ring@0.17.7
	rust-embed-impl@8.2.0
	rust-embed-utils@8.2.0
	rust-embed@8.2.0
	rustc-demangle@0.1.23
	rustix@0.38.31
	rustls-native-certs@0.6.3
	rustls-pemfile@1.0.4
	rustls-webpki@0.101.7
	rustls@0.21.10
	rustsec@0.28.6
	ryu@1.0.16
	same-file@1.0.6
	schannel@0.1.23
	scopeguard@1.2.0
	sct@0.7.1
	secrecy@0.8.0
	security-framework-sys@2.9.1
	security-framework@2.9.2
	semver@1.0.21
	serde@1.0.196
	serde_derive@1.0.196
	serde_json@1.0.113
	serde_spanned@0.6.5
	serde_urlencoded@0.7.1
	sha1_smol@1.0.0
	sha2@0.10.8
	sharded-slab@0.1.7
	shell-words@1.1.0
	slab@0.4.9
	slug@0.1.5
	smallvec@1.13.1
	smol_str@0.2.1
	socket2@0.5.5
	spin@0.9.8
	static_assertions@1.1.0
	strsim@0.10.0
	syn@1.0.109
	syn@2.0.48
	sync_wrapper@0.1.2
	synstructure@0.12.6
	system-configuration-sys@0.5.0
	system-configuration@0.5.1
	tame-index@0.9.3
	tempfile@3.9.0
	termcolor@1.4.1
	thiserror-impl@1.0.56
	thiserror@1.0.56
	thread_local@1.1.7
	time-core@0.1.2
	time-macros@0.2.18
	time@0.3.36
	tinyvec@1.6.0
	tinyvec_macros@0.1.1
	tokio-rustls@0.24.1
	tokio-util@0.7.10
	tokio@1.36.0
	toml@0.5.11
	toml@0.7.8
	toml@0.8.9
	toml_datetime@0.6.5
	toml_edit@0.19.15
	toml_edit@0.21.1
	toml_edit@0.22.5
	topological-sort@0.2.2
	tower-service@0.3.2
	tracing-attributes@0.1.27
	tracing-core@0.1.32
	tracing-log@0.1.4
	tracing-log@0.2.0
	tracing-subscriber@0.3.18
	tracing@0.1.40
	try-lock@0.2.5
	twox-hash@1.6.3
	typed-arena@2.0.2
	typenum@1.17.0
	uluru@3.0.0
	unicase@2.7.0
	unicode-bidi@0.3.15
	unicode-bom@2.0.3
	unicode-ident@1.0.12
	unicode-normalization@0.1.22
	unicode-xid@0.2.4
	unicode_categories@0.1.1
	untrusted@0.9.0
	url@2.5.0
	utf8parse@0.2.1
	valuable@0.1.0
	version_check@0.9.4
	wait-timeout@0.2.0
	walkdir@2.4.0
	want@0.3.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.90
	wasm-bindgen-futures@0.4.40
	wasm-bindgen-macro-support@0.2.90
	wasm-bindgen-macro@0.2.90
	wasm-bindgen-shared@0.2.90
	wasm-bindgen@0.2.90
	web-sys@0.3.67
	webpki-roots@0.25.4
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.6
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-targets@0.48.5
	windows-targets@0.52.0
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.0
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.0
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.0
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.0
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.0
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.0
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.0
	winnow@0.5.36
	winnow@0.6.1
	winreg@0.50.0
	xml-rs@0.8.19
	zeroize@1.7.0
"

inherit cargo

DESCRIPTION="Audit Cargo.lock for crates with security vulnerabilities"
HOMEPAGE="https://rustsec.org https://github.com/rustsec/cargo-audit"
SRC_URI="
	https://github.com/RustSec/rustsec/archive/refs/tags/${PN}/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/rustsec-${PN}-v${PV}"

LICENSE="|| ( Apache-2.0 MIT )"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD-2 BSD ISC MIT MPL-2.0 Unicode-DFS-2016"
SLOT="0"
KEYWORDS="~amd64 ~ppc64"
IUSE="fix"

RDEPEND="dev-libs/openssl:="
DEPEND="${RDEPEND}"

QA_FLAGS_IGNORED="usr/bin/${PN}"

# requires checkout of vuln db/network
PROPERTIES="test_network"
RESTRICT="test"

src_configure() {
	local myfeatures=(
		$(usev fix)
	)

	cargo_src_configure
}

src_compile() {
	# normally we can pass --bin cargo-audit
	# to build single workspace member, but we need to cd
	# for tests to be discovered properly
	cd cargo-audit || die
	cargo_src_compile
}

src_install() {
	cargo_src_install --path cargo-audit
	local DOCS=( cargo-audit/{README.md,audit.toml.example} )
	einstalldocs
}
