# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES="
	abscissa_core@0.8.1
	abscissa_derive@0.8.0
	addr2line@0.21.0
	adler2@2.0.0
	adler@1.0.2
	ahash@0.8.11
	aho-corasick@1.1.3
	allocator-api2@0.2.18
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.17
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.6
	anstyle@1.0.9
	arc-swap@1.7.1
	arrayvec@0.7.6
	askama@0.12.1
	askama_derive@0.12.5
	askama_escape@0.10.3
	askama_parser@0.2.1
	async-compression@0.4.17
	atom_syndication@0.12.4
	atomic-waker@1.1.2
	auditable-extract@0.3.5
	auditable-info@0.8.0
	auditable-serde@0.7.0
	autocfg@1.4.0
	backtrace@0.3.71
	base64@0.22.1
	basic-toml@0.1.9
	binfarce@0.2.1
	bitflags@2.6.0
	block-buffer@0.10.4
	borsh@1.5.1
	bstr@1.10.0
	bumpalo@3.16.0
	byteorder@1.5.0
	bytes@1.8.0
	camino@1.1.9
	canonical-path@2.0.2
	cc@1.1.31
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chrono@0.4.38
	clap@4.5.20
	clap_builder@4.5.20
	clap_derive@4.5.18
	clap_lex@0.7.2
	clru@0.6.2
	color-eyre@0.6.3
	colorchoice@1.0.3
	comrak@0.24.1
	core-foundation-sys@0.8.7
	core-foundation@0.9.4
	cpufeatures@0.2.14
	crc32fast@1.4.2
	crossbeam-channel@0.5.13
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.20
	crypto-common@0.1.6
	darling@0.20.10
	darling_core@0.20.10
	darling_macro@0.20.10
	deranged@0.3.11
	derive_builder@0.20.2
	derive_builder_core@0.20.2
	derive_builder_macro@0.20.2
	deunicode@1.6.0
	digest@0.10.7
	diligent-date-parser@0.1.4
	display-error-chain@0.2.2
	dunce@1.0.5
	either@1.13.0
	encoding_rs@0.8.35
	entities@1.0.1
	equivalent@1.0.1
	errno@0.3.9
	eyre@0.6.12
	faster-hex@0.9.0
	fastrand@2.1.1
	filetime@0.2.25
	fixedbitset@0.4.2
	flate2@1.0.34
	fnv@1.0.7
	form_urlencoded@1.2.1
	fs-err@2.11.0
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-io@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	generic-array@0.14.7
	getrandom@0.2.15
	gimli@0.28.1
	gix-actor@0.32.0
	gix-attributes@0.22.5
	gix-bitmap@0.2.12
	gix-chunk@0.4.9
	gix-command@0.3.10
	gix-commitgraph@0.24.3
	gix-config-value@0.14.9
	gix-config@0.40.0
	gix-credentials@0.24.5
	gix-date@0.9.1
	gix-diff@0.46.0
	gix-discover@0.35.0
	gix-features@0.38.2
	gix-filter@0.13.0
	gix-fs@0.11.3
	gix-glob@0.16.5
	gix-hash@0.14.2
	gix-hashtable@0.5.2
	gix-ignore@0.11.4
	gix-index@0.35.0
	gix-lock@14.0.0
	gix-negotiate@0.15.0
	gix-object@0.44.0
	gix-odb@0.63.0
	gix-pack@0.53.0
	gix-packetline-blocking@0.17.5
	gix-packetline@0.17.6
	gix-path@0.10.12
	gix-pathspec@0.7.7
	gix-prompt@0.8.8
	gix-protocol@0.45.3
	gix-quote@0.4.13
	gix-ref@0.47.0
	gix-refspec@0.25.0
	gix-revision@0.29.0
	gix-revwalk@0.15.0
	gix-sec@0.10.9
	gix-submodule@0.14.0
	gix-tempfile@14.0.2
	gix-trace@0.1.11
	gix-transport@0.42.3
	gix-traverse@0.41.0
	gix-url@0.27.5
	gix-utils@0.1.13
	gix-validate@0.9.1
	gix-worktree-state@0.13.0
	gix-worktree@0.36.0
	gix@0.66.0
	gumdrop@0.8.1
	gumdrop_derive@0.8.1
	h2@0.4.6
	hashbrown@0.14.5
	hashbrown@0.15.0
	heck@0.5.0
	hermit-abi@0.3.9
	home@0.5.9
	http-body-util@0.1.2
	http-body@1.0.1
	http@1.1.0
	httparse@1.9.5
	humansize@2.1.3
	hyper-rustls@0.27.3
	hyper-util@0.1.10
	hyper@1.5.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.61
	ident_case@1.0.1
	idna@0.5.0
	indenter@0.3.3
	indexmap@2.6.0
	io-close@0.3.7
	ipnet@2.10.1
	is_terminal_polyfill@1.70.1
	itoa@1.0.11
	jiff-tzdb-platform@0.1.1
	jiff-tzdb@0.1.1
	jiff@0.1.13
	js-sys@0.3.72
	kstring@2.0.2
	lazy_static@1.5.0
	libc@0.2.161
	libm@0.2.10
	libredox@0.1.3
	linux-raw-sys@0.4.14
	lock_api@0.4.12
	log@0.4.22
	matchers@0.1.0
	maybe-async@0.2.10
	memchr@2.7.4
	memmap2@0.9.5
	mime@0.3.17
	mime_guess@2.0.5
	minimal-lexical@0.2.1
	miniz_oxide@0.6.2
	miniz_oxide@0.7.4
	miniz_oxide@0.8.0
	mio@1.0.2
	never@0.1.0
	nom@7.1.3
	nu-ansi-term@0.46.0
	num-conv@0.1.0
	num-traits@0.2.19
	object@0.32.2
	once_cell@1.20.2
	openssl-probe@0.1.5
	overload@0.1.1
	owo-colors@3.5.0
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	percent-encoding@2.3.1
	petgraph@0.6.5
	pin-project-lite@0.2.15
	pin-utils@0.1.0
	powerfmt@0.2.0
	ppv-lite86@0.2.20
	proc-macro2@1.0.89
	prodash@28.0.0
	quick-xml@0.36.2
	quinn-proto@0.11.8
	quinn-udp@0.5.5
	quinn@0.11.5
	quote@1.0.37
	rand@0.8.5
	rand_chacha@0.3.1
	rand_core@0.6.4
	rayon-core@1.12.1
	rayon@1.10.0
	redox_syscall@0.5.7
	regex-automata@0.1.10
	regex-automata@0.4.8
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	reqwest@0.12.8
	ring@0.17.8
	rust-embed-impl@8.5.0
	rust-embed-utils@8.5.0
	rust-embed@8.5.0
	rustc-demangle@0.1.24
	rustc-hash@2.0.0
	rustix@0.38.38
	rustls-native-certs@0.8.0
	rustls-pemfile@2.2.0
	rustls-pki-types@1.10.0
	rustls-webpki@0.102.8
	rustls@0.23.16
	ryu@1.0.18
	same-file@1.0.6
	schannel@0.1.26
	scopeguard@1.2.0
	secrecy@0.10.3
	security-framework-sys@2.12.0
	security-framework@2.11.1
	semver@1.0.23
	serde@1.0.213
	serde_derive@1.0.213
	serde_json@1.0.132
	serde_spanned@0.6.8
	serde_urlencoded@0.7.1
	sha1_smol@1.0.1
	sha2@0.10.8
	sharded-slab@0.1.7
	shell-words@1.1.0
	shlex@1.3.0
	slab@0.4.9
	slug@0.1.6
	smallvec@1.13.2
	smol_str@0.3.2
	socket2@0.5.7
	spin@0.9.8
	static_assertions@1.1.0
	strsim@0.11.1
	subtle@2.6.1
	syn@1.0.109
	syn@2.0.85
	sync_wrapper@1.0.1
	synstructure@0.12.6
	system-configuration-sys@0.6.0
	system-configuration@0.6.1
	tame-index@0.14.0
	tempfile@3.13.0
	termcolor@1.4.1
	thiserror-impl@1.0.65
	thiserror@1.0.65
	thread_local@1.1.8
	time-core@0.1.2
	time-macros@0.2.18
	time@0.3.36
	tinyvec@1.8.0
	tinyvec_macros@0.1.1
	tokio-rustls@0.26.0
	tokio-util@0.7.12
	tokio@1.41.0
	toml-span@0.3.0
	toml@0.8.19
	toml_datetime@0.6.8
	toml_edit@0.22.22
	topological-sort@0.2.2
	tower-service@0.3.3
	tracing-attributes@0.1.27
	tracing-core@0.1.32
	tracing-log@0.2.0
	tracing-subscriber@0.3.18
	tracing@0.1.40
	try-lock@0.2.5
	twox-hash@1.6.3
	typed-arena@2.0.2
	typenum@1.17.0
	uluru@3.1.0
	unicase@2.8.0
	unicode-bidi@0.3.17
	unicode-bom@2.0.3
	unicode-ident@1.0.13
	unicode-normalization@0.1.24
	unicode-xid@0.2.6
	unicode_categories@0.1.1
	untrusted@0.9.0
	url@2.5.2
	utf8parse@0.2.2
	valuable@0.1.0
	version_check@0.9.5
	wait-timeout@0.2.0
	walkdir@2.5.0
	want@0.3.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.95
	wasm-bindgen-futures@0.4.45
	wasm-bindgen-macro-support@0.2.95
	wasm-bindgen-macro@0.2.95
	wasm-bindgen-shared@0.2.95
	wasm-bindgen@0.2.95
	wasmparser@0.207.0
	web-sys@0.3.72
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-registry@0.2.0
	windows-result@0.2.0
	windows-strings@0.1.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	winnow@0.6.20
	xml-rs@0.8.22
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
	zeroize@1.8.1
"

inherit cargo

DESCRIPTION="Audit Cargo.lock for crates with security vulnerabilities"
HOMEPAGE="https://rustsec.org https://github.com/rustsec/cargo-audit"
SRC_URI="
	https://github.com/RustSec/rustsec/archive/refs/tags/${PN}/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/rustsec-${PN}-v${PV}"

LICENSE="|| ( Apache-2.0 MIT )"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD ISC MIT MPL-2.0
	Unicode-DFS-2016
"
SLOT="0"
KEYWORDS="~amd64 ~ppc64"
IUSE="fix"

RDEPEND="dev-libs/openssl:="
DEPEND="${RDEPEND}"

QA_FLAGS_IGNORED="usr/bin/${PN}"

# requires checkout of vuln db/network
PROPERTIES="test_network"
RESTRICT="test"

src_configure() {
	local myfeatures=(
		$(usev fix)
	)

	cargo_src_configure
}

src_compile() {
	# normally we can pass --bin cargo-audit
	# to build single workspace member, but we need to cd
	# for tests to be discovered properly
	cd cargo-audit || die
	cargo_src_compile
}

src_install() {
	cargo_src_install --path cargo-audit
	local DOCS=( cargo-audit/{README.md,audit.toml.example} )
	einstalldocs
}
