# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

LUA_COMPAT=( lua5-1 )
LUA_REQ_USE="deprecated"

inherit autotools flag-o-matic lua-single

DESCRIPTION="A collection of different plugins for Geany"
HOMEPAGE="https://plugins.geany.org"
SRC_URI="https://plugins.geany.org/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 arm ppc ppc64 ~riscv ~sparc x86"

IUSE="ctags debugger enchant git gpg gtkspell lua markdown nls pretty-printer scope workbench"
REQUIRED_USE="lua? ( ${LUA_REQUIRED_USE} )"

DEPEND="
	dev-libs/glib:2
	>=dev-util/geany-1.37[-gtk2(-)]
	x11-libs/gtk+:3
	ctags? ( dev-util/ctags )
	debugger? ( x11-libs/vte:2.91 )
	enchant? ( app-text/enchant:= )
	git? ( dev-libs/libgit2:= )
	gpg? ( app-crypt/gpgme:= )
	gtkspell? ( app-text/gtkspell:3= )
	lua? ( ${LUA_DEPS} )
	markdown? (
		app-text/discount:=
		net-libs/webkit-gtk:4.1
		)
	pretty-printer? ( dev-libs/libxml2:2 )
	scope? ( x11-libs/vte:2.91 )
	workbench? ( dev-libs/libgit2:= )
"
RDEPEND="${DEPEND}
	scope? ( dev-debug/gdb )
"
BDEPEND="virtual/pkgconfig
	nls? ( sys-devel/gettext )
"

PATCHES=(
	"${FILESDIR}/${P}-libgit2-1.4.patch"
	"${FILESDIR}/${P}-webkit2gtk-4.1.patch"
)

pkg_setup() {
	use lua && lua-single_pkg_setup
}

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	# -DLUA_COMPAT_OPENLIB=1 is required to enable the
	# deprecated (in 5.1) luaL_openlib API (#878529)
	use lua_single_target_lua5-1 && append-cppflags -DLUA_COMPAT_OPENLIB=1

	local myeconfargs=(
		--disable-cppcheck
		--disable-extra-c-warnings
		$(use_enable nls)
		--enable-utilslib
		# Plugins
		--enable-addons
		--enable-autoclose
		--enable-automark
		--enable-codenav
		--enable-commander
		--enable-defineformat
		--enable-geanydoc
		--enable-geanyextrasel
		--enable-geanyinsertnum
		--enable-geanymacro
		--enable-geanyminiscript
		--enable-geanynumberedbookmarks
		--enable-geanyprj
		--enable-geanyvc $(use_enable gtkspell)
		--enable-keyrecord
		--enable-latex
		--enable-lineoperations
		--enable-lipsum
		--enable-overview
		--enable-pairtaghighlighter
		--enable-pohelper
		--enable-projectorganizer
		--enable-sendmail
		--enable-shiftcolumn
		--enable-tableconvert
		--enable-treebrowser
		--enable-vimode
		--enable-xmlsnippets
		$(use_enable debugger)
		$(use_enable ctags geanyctags)
		$(use_enable lua geanylua)
		$(use_enable gpg geanypg)
		$(use_enable git gitchangebar)
		$(use_enable markdown) --disable-peg-markdown # using app-text/discount instead
		$(use_enable pretty-printer)
		$(use_enable scope)
		$(use_enable enchant spellcheck)
		$(use_enable workbench)
		# GeanyGenDoc requires ctpl which isn’t yet in portage
		--disable-geanygendoc
		# Require libsoup-2.4 which conflicts with webkit2gtk-4.1
		--disable-geniuspaste
		--disable-updatechecker
		# Require obsolete and vulnerable webkit-gtk versions
		--disable-devhelp
		--disable-webhelper
		# GTK 2 only
		--disable-geanypy
		--disable-multiterm
	)

	econf "${myeconfargs[@]}"
}

src_install() {
	default

	find "${D}" -name '*.la' -delete || die

	# make installs all translations if LINGUAS is empty
	if [[ -z "${LINGUAS-x}" ]]; then
		rm -r "${ED}/usr/share/locale/" || die
	fi
}
