# Copyright 1999-2021 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI="7"

DESCRIPTION="Tool for editing VCS repositories and translating among different systems"
HOMEPAGE="http://www.catb.org/~esr/reposurgeon/"

if [[ ${PV} == "9999" ]]; then
	EGIT_REPO_URI="https://gitlab.com/esr/reposurgeon.git"
	inherit git-r3
else
	SRC_URI="http://www.catb.org/~esr/${PN}/${P}.tar.xz"
	KEYWORDS="~amd64 ~x86"
fi
inherit go-module

LICENSE="BSD-2"
SLOT="0"

IUSE=""

RDEPEND=""

DEPEND="${RDEPEND}
	virtual/pkgconfig
	app-text/xmlto
	app-text/asciidoc
	dev-ruby/asciidoctor"

#DOCS=( README.md CONFIGURATION.md INTRODUCTION.md LICENSE LICENSE.pycrc LICENSE.snappy )

PATCHES=(
		"${FILESDIR}"/reposurgeon-4.27-docdir.patch
)

EGO_SUM=(
	'cloud.google.com/go v0.26.0/go.mod'
	'github.com/BurntSushi/toml v0.3.1/go.mod'
	'github.com/OneOfOne/xxhash v1.2.2/go.mod'
	'github.com/alecthomas/template v0.0.0-20160405071501-a0175ee3bccc/go.mod'
	'github.com/alecthomas/units v0.0.0-20151022065526-2efee857e7cf/go.mod'
	'github.com/anmitsu/go-shlex v0.0.0-20161002113705-648efa622239'
	'github.com/anmitsu/go-shlex v0.0.0-20161002113705-648efa622239/go.mod'
	'github.com/anmitsu/go-shlex v0.0.0-20200514113438-38f4b401e2be'
	'github.com/anmitsu/go-shlex v0.0.0-20200514113438-38f4b401e2be/go.mod'
	'github.com/armon/consul-api v0.0.0-20180202201655-eb2c6b5be1b6/go.mod'
	'github.com/beorn7/perks v0.0.0-20180321164747-3a771d992973/go.mod'
	'github.com/beorn7/perks v1.0.0/go.mod'
	'github.com/cespare/xxhash v1.1.0/go.mod'
	'github.com/chzyer/logex v1.1.10'
	'github.com/chzyer/logex v1.1.10/go.mod'
	'github.com/chzyer/readline v0.0.0-20180603132655-2972be24d48e'
	'github.com/chzyer/readline v0.0.0-20180603132655-2972be24d48e/go.mod'
	'github.com/chzyer/test v0.0.0-20180213035817-a1ea475d72b1'
	'github.com/chzyer/test v0.0.0-20180213035817-a1ea475d72b1/go.mod'
	'github.com/client9/misspell v0.3.4/go.mod'
	'github.com/coreos/bbolt v1.3.2/go.mod'
	'github.com/coreos/etcd v3.3.10+incompatible/go.mod'
	'github.com/coreos/go-semver v0.2.0/go.mod'
	'github.com/coreos/go-systemd v0.0.0-20190321100706-95778dfbb74e/go.mod'
	'github.com/coreos/pkg v0.0.0-20180928190104-399ea9e2e55f/go.mod'
	'github.com/cosiner/argv v0.0.0-20170225145430-13bacc38a0a5'
	'github.com/cosiner/argv v0.0.0-20170225145430-13bacc38a0a5/go.mod'
	'github.com/cosiner/argv v0.0.1'
	'github.com/cosiner/argv v0.0.1/go.mod'
	'github.com/cpuguy83/go-md2man v1.0.8/go.mod'
	'github.com/cpuguy83/go-md2man/v2 v2.0.0/go.mod'
	'github.com/davecgh/go-spew v1.1.0/go.mod'
	'github.com/davecgh/go-spew v1.1.1/go.mod'
	'github.com/dgrijalva/jwt-go v3.2.0+incompatible/go.mod'
	'github.com/dgryski/go-sip13 v0.0.0-20181026042036-e10d5fee7954/go.mod'
	'github.com/emirpasic/gods v1.12.0'
	'github.com/emirpasic/gods v1.12.0/go.mod'
	'github.com/flynn/go-shlex v0.0.0-20150515145356-3f9db97f8568'
	'github.com/flynn/go-shlex v0.0.0-20150515145356-3f9db97f8568/go.mod'
	'github.com/fsnotify/fsnotify v1.4.7/go.mod'
	'github.com/ghodss/yaml v1.0.0/go.mod'
	'github.com/go-delve/delve v1.4.0'
	'github.com/go-delve/delve v1.4.0/go.mod'
	'github.com/go-kit/kit v0.8.0/go.mod'
	'github.com/go-logfmt/logfmt v0.3.0/go.mod'
	'github.com/go-logfmt/logfmt v0.4.0/go.mod'
	'github.com/go-stack/stack v1.8.0/go.mod'
	'github.com/gogo/protobuf v1.1.1/go.mod'
	'github.com/gogo/protobuf v1.2.1/go.mod'
	'github.com/golang/glog v0.0.0-20160126235308-23def4e6c14b/go.mod'
	'github.com/golang/groupcache v0.0.0-20190129154638-5b532d6fd5ef/go.mod'
	'github.com/golang/mock v1.1.1/go.mod'
	'github.com/golang/protobuf v1.2.0/go.mod'
	'github.com/golang/protobuf v1.3.1/go.mod'
	'github.com/google/btree v1.0.0/go.mod'
	'github.com/google/go-cmp v0.2.0/go.mod'
	'github.com/gorilla/websocket v1.4.0/go.mod'
	'github.com/grpc-ecosystem/go-grpc-middleware v1.0.0/go.mod'
	'github.com/grpc-ecosystem/go-grpc-prometheus v1.2.0/go.mod'
	'github.com/grpc-ecosystem/grpc-gateway v1.9.0/go.mod'
	'github.com/hashicorp/hcl v1.0.0/go.mod'
	'github.com/hpcloud/tail v1.0.0/go.mod'
	'github.com/ianbruene/go-difflib v1.1.2'
	'github.com/ianbruene/go-difflib v1.1.2/go.mod'
	'github.com/ianbruene/go-difflib v1.2.0'
	'github.com/ianbruene/go-difflib v1.2.0/go.mod'
	'github.com/inconshreveable/mousetrap v1.0.0'
	'github.com/inconshreveable/mousetrap v1.0.0/go.mod'
	'github.com/jonboulle/clockwork v0.1.0/go.mod'
	'github.com/julienschmidt/httprouter v1.2.0/go.mod'
	'github.com/kballard/go-shellquote v0.0.0-20180428030007-95032a82bc51'
	'github.com/kballard/go-shellquote v0.0.0-20180428030007-95032a82bc51/go.mod'
	'github.com/kisielk/errcheck v1.1.0/go.mod'
	'github.com/kisielk/gotool v1.0.0/go.mod'
	'github.com/konsorten/go-windows-terminal-sequences v1.0.1'
	'github.com/konsorten/go-windows-terminal-sequences v1.0.1/go.mod'
	'github.com/konsorten/go-windows-terminal-sequences v1.0.2'
	'github.com/konsorten/go-windows-terminal-sequences v1.0.2/go.mod'
	'github.com/kr/logfmt v0.0.0-20140226030751-b84e30acd515/go.mod'
	'github.com/kr/pretty v0.1.0/go.mod'
	'github.com/kr/pty v1.1.1/go.mod'
	'github.com/kr/text v0.1.0/go.mod'
	'github.com/magiconair/properties v1.8.0/go.mod'
	'github.com/mattn/go-colorable v0.0.0-20170327083344-ded68f7a9561'
	'github.com/mattn/go-colorable v0.0.0-20170327083344-ded68f7a9561/go.mod'
	'github.com/mattn/go-colorable v0.1.6'
	'github.com/mattn/go-colorable v0.1.6/go.mod'
	'github.com/mattn/go-isatty v0.0.3'
	'github.com/mattn/go-isatty v0.0.3/go.mod'
	'github.com/mattn/go-isatty v0.0.12'
	'github.com/mattn/go-isatty v0.0.12/go.mod'
	'github.com/mattn/go-runewidth v0.0.3'
	'github.com/mattn/go-runewidth v0.0.3/go.mod'
	'github.com/mattn/go-runewidth v0.0.8'
	'github.com/mattn/go-runewidth v0.0.8/go.mod'
	'github.com/matttproud/golang_protobuf_extensions v1.0.1/go.mod'
	'github.com/mitchellh/go-homedir v1.1.0/go.mod'
	'github.com/mitchellh/mapstructure v1.1.2/go.mod'
	'github.com/mwitkow/go-conntrack v0.0.0-20161129095857-cc309e4a2223/go.mod'
	'github.com/oklog/ulid v1.3.1/go.mod'
	'github.com/onsi/ginkgo v1.6.0/go.mod'
	'github.com/onsi/ginkgo v1.8.0/go.mod'
	'github.com/onsi/gomega v1.5.0/go.mod'
	'github.com/orcaman/concurrent-map v0.0.0-20190826125027-8c72a8bb44f6'
	'github.com/orcaman/concurrent-map v0.0.0-20190826125027-8c72a8bb44f6/go.mod'
	'github.com/pelletier/go-toml v1.2.0/go.mod'
	'github.com/peterh/liner v0.0.0-20170317030525-88609521dc4b'
	'github.com/peterh/liner v0.0.0-20170317030525-88609521dc4b/go.mod'
	'github.com/peterh/liner v1.2.0'
	'github.com/peterh/liner v1.2.0/go.mod'
	'github.com/pkg/errors v0.8.0/go.mod'
	'github.com/pkg/profile v0.0.0-20170413231811-06b906832ed0/go.mod'
	'github.com/pmezard/go-difflib v1.0.0/go.mod'
	'github.com/prometheus/client_golang v0.9.1/go.mod'
	'github.com/prometheus/client_golang v0.9.3/go.mod'
	'github.com/prometheus/client_model v0.0.0-20180712105110-5c3871d89910/go.mod'
	'github.com/prometheus/client_model v0.0.0-20190129233127-fd36f4220a90/go.mod'
	'github.com/prometheus/common v0.0.0-20181113130724-41aa239b4cce/go.mod'
	'github.com/prometheus/common v0.4.0/go.mod'
	'github.com/prometheus/procfs v0.0.0-20181005140218-185b4288413d/go.mod'
	'github.com/prometheus/procfs v0.0.0-20190507164030-5867b95ac084/go.mod'
	'github.com/prometheus/tsdb v0.7.1/go.mod'
	'github.com/rogpeppe/fastuuid v0.0.0-20150106093220-6724a57986af/go.mod'
	'github.com/russross/blackfriday v0.0.0-20180428102519-11635eb403ff/go.mod'
	'github.com/russross/blackfriday/v2 v2.0.1/go.mod'
	'github.com/shurcooL/sanitized_anchor_name v1.0.0/go.mod'
	'github.com/sirupsen/logrus v0.0.0-20180523074243-ea8897e79973'
	'github.com/sirupsen/logrus v0.0.0-20180523074243-ea8897e79973/go.mod'
	'github.com/sirupsen/logrus v1.2.0/go.mod'
	'github.com/sirupsen/logrus v1.4.2'
	'github.com/sirupsen/logrus v1.4.2/go.mod'
	'github.com/soheilhy/cmux v0.1.4/go.mod'
	'github.com/spaolacci/murmur3 v0.0.0-20180118202830-f09979ecbc72/go.mod'
	'github.com/spf13/afero v1.1.2/go.mod'
	'github.com/spf13/cast v1.3.0/go.mod'
	'github.com/spf13/cobra v0.0.0-20170417170307-b6cb39589372'
	'github.com/spf13/cobra v0.0.0-20170417170307-b6cb39589372/go.mod'
	'github.com/spf13/cobra v0.0.6'
	'github.com/spf13/cobra v0.0.6/go.mod'
	'github.com/spf13/jwalterweatherman v1.0.0/go.mod'
	'github.com/spf13/pflag v0.0.0-20170417173400-9e4c21054fa1'
	'github.com/spf13/pflag v0.0.0-20170417173400-9e4c21054fa1/go.mod'
	'github.com/spf13/pflag v1.0.3/go.mod'
	'github.com/spf13/pflag v1.0.5'
	'github.com/spf13/pflag v1.0.5/go.mod'
	'github.com/spf13/viper v1.4.0/go.mod'
	'github.com/stretchr/objx v0.1.0/go.mod'
	'github.com/stretchr/objx v0.1.1/go.mod'
	'github.com/stretchr/testify v1.2.2/go.mod'
	'github.com/stretchr/testify v1.3.0/go.mod'
	'github.com/termie/go-shutil v0.0.0-20140729215957-bcacb06fecae'
	'github.com/termie/go-shutil v0.0.0-20140729215957-bcacb06fecae/go.mod'
	'github.com/tmc/grpc-websocket-proxy v0.0.0-20190109142713-0ad062ec5ee5/go.mod'
	'github.com/ugorji/go v1.1.4/go.mod'
	'github.com/xiang90/probing v0.0.0-20190116061207-43a291ad63a2/go.mod'
	'github.com/xo/terminfo v0.0.0-20210125001918-ca9a967f8778'
	'github.com/xo/terminfo v0.0.0-20210125001918-ca9a967f8778/go.mod'
	'github.com/xordataexchange/crypt v0.0.3-0.20170626215501-b2862e3d0a77/go.mod'
	'gitlab.com/esr/fqme v0.1.0'
	'gitlab.com/esr/fqme v0.1.0/go.mod'
	'gitlab.com/ianbruene/kommandant v0.5.3'
	'gitlab.com/ianbruene/kommandant v0.5.3/go.mod'
	'gitlab.com/ianbruene/kommandant v0.6.1'
	'gitlab.com/ianbruene/kommandant v0.6.1/go.mod'
	'gitlab.com/ianbruene/kommandant v0.6.2'
	'gitlab.com/ianbruene/kommandant v0.6.2/go.mod'
	'go.etcd.io/bbolt v1.3.2/go.mod'
	'go.starlark.net v0.0.0-20190702223751-32f345186213'
	'go.starlark.net v0.0.0-20190702223751-32f345186213/go.mod'
	'go.starlark.net v0.0.0-20200306205701-8dd3e2ee1dd5'
	'go.starlark.net v0.0.0-20200306205701-8dd3e2ee1dd5/go.mod'
	'go.uber.org/atomic v1.4.0/go.mod'
	'go.uber.org/multierr v1.1.0/go.mod'
	'go.uber.org/zap v1.10.0/go.mod'
	'golang.org/x/arch v0.0.0-20190927153633-4e8777c89be4'
	'golang.org/x/arch v0.0.0-20190927153633-4e8777c89be4/go.mod'
	'golang.org/x/arch v0.0.0-20200312215426-ff8b605520f4'
	'golang.org/x/arch v0.0.0-20200312215426-ff8b605520f4/go.mod'
	'golang.org/x/crypto v0.0.0-20180904163835-0709b304e793/go.mod'
	'golang.org/x/crypto v0.0.0-20190308221718-c2843e01d9a2/go.mod'
	'golang.org/x/crypto v0.0.0-20191206172530-e9b2fee46413'
	'golang.org/x/crypto v0.0.0-20191206172530-e9b2fee46413/go.mod'
	'golang.org/x/crypto v0.0.0-20200311171314-f7b00557c8c4'
	'golang.org/x/crypto v0.0.0-20200311171314-f7b00557c8c4/go.mod'
	'golang.org/x/crypto v0.0.0-20200406173513-056763e48d71'
	'golang.org/x/crypto v0.0.0-20200406173513-056763e48d71/go.mod'
	'golang.org/x/crypto v0.0.0-20200510223506-06a226fb4e37'
	'golang.org/x/crypto v0.0.0-20200510223506-06a226fb4e37/go.mod'
	'golang.org/x/crypto v0.0.0-20201221181555-eec23a3978ad'
	'golang.org/x/crypto v0.0.0-20201221181555-eec23a3978ad/go.mod'
	'golang.org/x/crypto v0.0.0-20210322153248-0c34fe9e7dc2'
	'golang.org/x/crypto v0.0.0-20210322153248-0c34fe9e7dc2/go.mod'
	'golang.org/x/lint v0.0.0-20181026193005-c67002cb31c3/go.mod'
	'golang.org/x/lint v0.0.0-20190313153728-d0100b6bd8b3/go.mod'
	'golang.org/x/net v0.0.0-20180826012351-8a410e7b638d/go.mod'
	'golang.org/x/net v0.0.0-20180906233101-161cd47e91fd/go.mod'
	'golang.org/x/net v0.0.0-20181114220301-adae6a3d119a/go.mod'
	'golang.org/x/net v0.0.0-20181220203305-927f97764cc3/go.mod'
	'golang.org/x/net v0.0.0-20190311183353-d8887717615a/go.mod'
	'golang.org/x/net v0.0.0-20190404232315-eb5bcb51f2a3/go.mod'
	'golang.org/x/net v0.0.0-20190522155817-f3200d17e092/go.mod'
	'golang.org/x/net v0.0.0-20190620200207-3b0461eec859/go.mod'
	'golang.org/x/net v0.0.0-20210226172049-e18ecbb05110/go.mod'
	'golang.org/x/oauth2 v0.0.0-20180821212333-d2e6202438be/go.mod'
	'golang.org/x/sync v0.0.0-20180314180146-1d60e4601c6f/go.mod'
	'golang.org/x/sync v0.0.0-20181108010431-42b317875d0f/go.mod'
	'golang.org/x/sync v0.0.0-20181221193216-37e7f081c4d4/go.mod'
	'golang.org/x/sync v0.0.0-20190423024810-112230192c58/go.mod'
	'golang.org/x/sys v0.0.0-20180830151530-49385e6e1522/go.mod'
	'golang.org/x/sys v0.0.0-20180905080454-ebe1bf3edb33/go.mod'
	'golang.org/x/sys v0.0.0-20180909124046-d0be0721c37e/go.mod'
	'golang.org/x/sys v0.0.0-20181107165924-66b7b1311ac8/go.mod'
	'golang.org/x/sys v0.0.0-20181116152217-5ac8a444bdc5/go.mod'
	'golang.org/x/sys v0.0.0-20190215142949-d0b11bdaac8a/go.mod'
	'golang.org/x/sys v0.0.0-20190412213103-97732733099d/go.mod'
	'golang.org/x/sys v0.0.0-20190422165155-953cdadca894/go.mod'
	'golang.org/x/sys v0.0.0-20190626221950-04f50cda93cb/go.mod'
	'golang.org/x/sys v0.0.0-20191002063906-3421d5a6bb1c/go.mod'
	'golang.org/x/sys v0.0.0-20191026070338-33540a1f6037/go.mod'
	'golang.org/x/sys v0.0.0-20191210023423-ac6580df4449'
	'golang.org/x/sys v0.0.0-20191210023423-ac6580df4449/go.mod'
	'golang.org/x/sys v0.0.0-20200116001909-b77594299b42/go.mod'
	'golang.org/x/sys v0.0.0-20200223170610-d5e6a3e2c0ae'
	'golang.org/x/sys v0.0.0-20200223170610-d5e6a3e2c0ae/go.mod'
	'golang.org/x/sys v0.0.0-20200316230553-a7d97aace0b0'
	'golang.org/x/sys v0.0.0-20200316230553-a7d97aace0b0/go.mod'
	'golang.org/x/sys v0.0.0-20200408040146-ea54a3c99b9b'
	'golang.org/x/sys v0.0.0-20200408040146-ea54a3c99b9b/go.mod'
	'golang.org/x/sys v0.0.0-20200409092240-59c9f1ba88fa'
	'golang.org/x/sys v0.0.0-20200409092240-59c9f1ba88fa/go.mod'
	'golang.org/x/sys v0.0.0-20200515095857-1151b9dac4a9'
	'golang.org/x/sys v0.0.0-20200515095857-1151b9dac4a9/go.mod'
	'golang.org/x/sys v0.0.0-20201119102817-f84b799fce68/go.mod'
	'golang.org/x/sys v0.0.0-20201223074533-0d417f636930'
	'golang.org/x/sys v0.0.0-20201223074533-0d417f636930/go.mod'
	'golang.org/x/sys v0.0.0-20210403161142-5e06dd20ab57'
	'golang.org/x/sys v0.0.0-20210403161142-5e06dd20ab57/go.mod'
	'golang.org/x/term v0.0.0-20201117132131-f5c789dd3221'
	'golang.org/x/term v0.0.0-20201117132131-f5c789dd3221/go.mod'
	'golang.org/x/term v0.0.0-20201126162022-7de9c90e9dd1/go.mod'
	'golang.org/x/term v0.0.0-20201210144234-2321bbc49cbf'
	'golang.org/x/term v0.0.0-20201210144234-2321bbc49cbf/go.mod'
	'golang.org/x/term v0.0.0-20210406210042-72f3dc4e9b72'
	'golang.org/x/term v0.0.0-20210406210042-72f3dc4e9b72/go.mod'
	'golang.org/x/text v0.3.0/go.mod'
	'golang.org/x/text v0.3.2'
	'golang.org/x/text v0.3.2/go.mod'
	'golang.org/x/text v0.3.3/go.mod'
	'golang.org/x/text v0.3.4'
	'golang.org/x/text v0.3.4/go.mod'
	'golang.org/x/text v0.3.6'
	'golang.org/x/text v0.3.6/go.mod'
	'golang.org/x/time v0.0.0-20190308202827-9d24e82272b4/go.mod'
	'golang.org/x/tools v0.0.0-20180221164845-07fd8470d635/go.mod'
	'golang.org/x/tools v0.0.0-20180917221912-90fa682c2a6e/go.mod'
	'golang.org/x/tools v0.0.0-20190114222345-bf090417da8b/go.mod'
	'golang.org/x/tools v0.0.0-20190311212946-11955173bddd/go.mod'
	'golang.org/x/tools v0.0.0-20191127201027-ecd32218bd7f/go.mod'
	'golang.org/x/xerrors v0.0.0-20190717185122-a985d3407aa7/go.mod'
	'google.golang.org/appengine v1.1.0/go.mod'
	'google.golang.org/genproto v0.0.0-20180817151627-c66870c02cf8/go.mod'
	'google.golang.org/grpc v1.19.0/go.mod'
	'google.golang.org/grpc v1.21.0/go.mod'
	'gopkg.in/airbrake/gobrake.v2 v2.0.9/go.mod'
	'gopkg.in/alecthomas/kingpin.v2 v2.2.6/go.mod'
	'gopkg.in/check.v1 v0.0.0-20161208181325-20d25e280405/go.mod'
	'gopkg.in/check.v1 v1.0.0-20180628173108-788fd7840127/go.mod'
	'gopkg.in/fsnotify.v1 v1.4.7/go.mod'
	'gopkg.in/gemnasium/logrus-airbrake-hook.v2 v2.1.2/go.mod'
	'gopkg.in/resty.v1 v1.12.0/go.mod'
	'gopkg.in/tomb.v1 v1.0.0-20141024135613-dd632973f1e7/go.mod'
	'gopkg.in/yaml.v2 v2.0.0-20170812160011-eb3733d160e7/go.mod'
	'gopkg.in/yaml.v2 v2.2.1'
	'gopkg.in/yaml.v2 v2.2.1/go.mod'
	'gopkg.in/yaml.v2 v2.2.2/go.mod'
	'gopkg.in/yaml.v2 v2.2.8'
	'gopkg.in/yaml.v2 v2.2.8/go.mod'
	'honnef.co/go/tools v0.0.0-20190102054323-c2f93a96b099/go.mod'
	'rsc.io/pdf v0.1.1/go.mod'
)

go-module_set_globals
SRC_URI+=" ${EGO_SUM_SRC_URI}"

src_compile() {
	emake all
}

src_install() {
	emake DESTDIR="${ED}" prefix="/usr" docdir="share/doc/${P}" install
}
