# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES="
	adler2@2.0.0
	ahash@0.8.11
	allocator-api2@0.2.18
	anstream@0.6.15
	anstyle-parse@0.2.5
	anstyle-query@1.1.1
	anstyle-wincon@3.0.4
	anstyle@1.0.8
	anyhow@1.0.87
	arc-swap@1.7.1
	autocfg@1.3.0
	bitflags@2.6.0
	bstr@1.10.0
	bzip2-rs@0.1.2
	cc@1.1.18
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	clap@4.5.17
	clap_builder@4.5.17
	clap_lex@0.7.2
	clru@0.6.2
	colorchoice@1.0.2
	crc32fast@1.4.2
	ctrlc@3.4.5
	curl-sys@0.4.74+curl-8.9.0
	curl@0.4.46
	dunce@1.0.5
	encoding_rs@0.8.34
	equivalent@1.0.1
	errno@0.3.9
	faster-hex@0.9.0
	fastrand@2.1.1
	filetime@0.2.25
	flate2@1.0.33
	fnv@1.0.7
	form_urlencoded@1.2.1
	gix-actor@0.32.0
	gix-bitmap@0.2.11
	gix-chunk@0.4.8
	gix-command@0.3.9
	gix-commitgraph@0.24.3
	gix-config-value@0.14.8
	gix-config@0.40.0
	gix-date@0.9.0
	gix-diff@0.46.0
	gix-discover@0.35.0
	gix-features@0.38.2
	gix-fs@0.11.3
	gix-glob@0.16.5
	gix-hash@0.14.2
	gix-hashtable@0.5.2
	gix-index@0.35.0
	gix-lock@14.0.0
	gix-object@0.44.0
	gix-odb@0.63.0
	gix-pack@0.53.0
	gix-path@0.10.11
	gix-quote@0.4.12
	gix-ref@0.47.0
	gix-refspec@0.25.0
	gix-revision@0.29.0
	gix-revwalk@0.15.0
	gix-sec@0.10.8
	gix-tempfile@14.0.2
	gix-trace@0.1.10
	gix-traverse@0.41.0
	gix-url@0.27.5
	gix-utils@0.1.12
	gix-validate@0.9.0
	gix@0.66.0
	hashbrown@0.14.5
	hermit-abi@0.4.0
	home@0.5.9
	idna@0.5.0
	indexmap@2.5.0
	is-terminal@0.4.13
	is_terminal_polyfill@1.70.1
	itoa@1.0.11
	jiff-tzdb-platform@0.1.1
	jiff-tzdb@0.1.1
	jiff@0.1.13
	libc@0.2.158
	libredox@0.1.3
	libz-sys@1.1.20
	linux-raw-sys@0.4.14
	lock_api@0.4.12
	memchr@2.7.4
	memmap2@0.9.4
	miniz_oxide@0.8.0
	nix@0.29.0
	once_cell@1.19.0
	openssl-probe@0.1.5
	openssl-sys@0.9.103
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	percent-encoding@2.3.1
	pkg-config@0.3.30
	proc-macro2@1.0.86
	prodash@28.0.0
	quote@1.0.37
	redox_syscall@0.5.3
	regex-automata@0.4.7
	rustix@0.38.36
	ryu@1.0.18
	same-file@1.0.6
	schannel@0.1.24
	scopeguard@1.2.0
	serde@1.0.210
	serde_derive@1.0.210
	serde_json@1.0.128
	sha1_smol@1.0.1
	shell-words@1.1.0
	shlex@1.3.0
	smallvec@1.13.2
	socket2@0.5.7
	strsim@0.11.1
	syn@2.0.77
	tar@0.4.41
	tempfile@3.12.0
	termcolor@1.4.1
	terminal_size@0.3.0
	thiserror-impl@1.0.63
	thiserror@1.0.63
	tinyvec@1.8.0
	tinyvec_macros@0.1.1
	unicode-bidi@0.3.15
	unicode-bom@2.0.3
	unicode-ident@1.0.12
	unicode-normalization@0.1.23
	url@2.5.2
	utf8parse@0.2.2
	vcpkg@0.2.15
	version_check@0.9.5
	walkdir@2.5.0
	winapi-util@0.1.9
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.6.18
	xattr@1.3.1
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
"

inherit cargo flag-o-matic

DESCRIPTION="Stack-based patch management for Git"
HOMEPAGE="https://stacked-git.github.io/"
SRC_URI="${CARGO_CRATE_URIS}"
SRC_URI+=" https://github.com/stacked-git/stgit/releases/download/v${PV}/${P}.tar.gz"

LICENSE="GPL-2"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT Unicode-DFS-2016"
SLOT="0/2"
KEYWORDS="~amd64 ~arm ~arm64 ~ppc ~ppc64 ~riscv ~x86"
IUSE="doc"

DEPEND="doc? ( app-text/asciidoc )"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/stg"

src_configure() {
	filter-lto #bug 897692
}

src_compile() {
	cargo_src_compile
	emake completion
	emake contrib
	use doc && emake doc
}

src_install() {
	cargo_src_install
	emake DESTDIR="${D}" prefix="/usr" install-completion
	emake DESTDIR="${D}" prefix="/usr" install-contrib
	if use doc; then
		emake DESTDIR="${D}" prefix="/usr" install-man
		emake DESTDIR="${D}" prefix="/usr" \
			htmldir="/usr/share/doc/${PF}"  \
			install-html
	fi
}
