# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES="
	addr2line@0.22.0
	adler@1.0.2
	ahash@0.8.11
	aho-corasick@1.1.3
	ansi_term@0.12.1
	anstream@0.6.14
	anstyle-parse@0.2.4
	anstyle-query@1.1.0
	anstyle-wincon@3.0.3
	anstyle@1.0.7
	anyhow@1.0.86
	async-channel@1.9.0
	async-channel@2.3.1
	async-executor@1.12.0
	async-global-executor@2.4.1
	async-io@1.13.0
	async-io@2.3.3
	async-lock@2.8.0
	async-lock@3.4.0
	async-std@1.12.0
	async-task@4.7.1
	async-trait@0.1.81
	atomic-waker@1.1.2
	autocfg@1.3.0
	backtrace@0.3.73
	base64@0.21.7
	bitflags@1.3.2
	bitflags@2.6.0
	blocking@1.6.1
	bumpalo@3.16.0
	bytes@1.6.0
	cc@1.0.106
	cfg-if@1.0.0
	cidr-utils@0.6.1
	cidr@0.2.3
	clap@4.5.8
	clap_builder@4.5.8
	clap_derive@4.5.8
	clap_lex@0.7.1
	colorchoice@1.0.1
	colored@2.1.0
	colorful@0.2.2
	concurrent-queue@2.5.0
	crossbeam-utils@0.8.20
	data-encoding@2.6.0
	dirs-sys@0.4.1
	dirs@5.0.1
	either@1.13.0
	enum-as-inner@0.6.0
	env_filter@0.1.0
	env_logger@0.11.3
	equivalent@1.0.1
	errno@0.3.9
	event-listener-strategy@0.5.2
	event-listener@2.5.3
	event-listener@5.3.1
	fastrand@1.9.0
	fastrand@2.1.0
	form_urlencoded@1.2.1
	futures-channel@0.3.30
	futures-core@0.3.30
	futures-executor@0.3.30
	futures-io@0.3.30
	futures-lite@1.13.0
	futures-lite@2.3.0
	futures-macro@0.3.30
	futures-sink@0.3.30
	futures-task@0.3.30
	futures-util@0.3.30
	futures@0.3.30
	gcd@2.3.0
	getrandom@0.2.15
	gimli@0.29.0
	gloo-timers@0.2.6
	hashbrown@0.12.3
	hashbrown@0.13.2
	hashbrown@0.14.5
	heck@0.4.1
	heck@0.5.0
	hermit-abi@0.3.9
	hermit-abi@0.4.0
	hickory-proto@0.24.1
	hickory-resolver@0.24.1
	hostname@0.3.1
	humantime@2.1.0
	idna@0.4.0
	idna@0.5.0
	indexmap@1.9.3
	indexmap@2.2.6
	instant@0.1.13
	io-lifetimes@1.0.11
	ipconfig@0.3.2
	ipnet@2.9.0
	is_terminal_polyfill@1.70.0
	itertools@0.13.0
	itoa@1.0.11
	js-sys@0.3.69
	kv-log-macro@1.0.7
	lazy_static@1.5.0
	libc@0.2.155
	libredox@0.1.3
	linked-hash-map@0.5.6
	linux-raw-sys@0.3.8
	linux-raw-sys@0.4.14
	lock_api@0.4.12
	log@0.4.22
	lru-cache@0.1.2
	match_cfg@0.1.0
	memchr@2.7.4
	miniz_oxide@0.7.4
	mio@0.8.11
	num-bigint@0.4.6
	num-integer@0.1.46
	num-traits@0.2.19
	num_cpus@1.16.0
	object@0.36.1
	once_cell@1.19.0
	option-ext@0.2.0
	parameterized-macro@2.0.0
	parameterized@2.0.0
	parking@2.2.0
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	percent-encoding@2.3.1
	pin-project-lite@0.2.14
	pin-utils@0.1.0
	piper@0.2.3
	polling@2.8.0
	polling@3.7.2
	ppv-lite86@0.2.17
	proc-macro2@1.0.86
	quick-error@1.2.3
	quote@1.0.36
	rand@0.8.5
	rand_chacha@0.3.1
	rand_core@0.6.4
	redox_syscall@0.5.2
	redox_users@0.4.5
	regex-automata@0.4.7
	regex-syntax@0.8.4
	regex@1.10.5
	resolv-conf@0.7.0
	ring@0.17.8
	rlimit@0.10.1
	rustc-demangle@0.1.24
	rustix@0.37.27
	rustix@0.38.34
	rustls-pemfile@1.0.4
	rustls-webpki@0.101.7
	rustls@0.21.12
	ryu@1.0.18
	scopeguard@1.2.0
	sct@0.7.1
	serde@1.0.204
	serde_derive@1.0.204
	serde_json@1.0.120
	serde_spanned@0.6.6
	slab@0.4.9
	smallvec@1.13.2
	socket2@0.4.10
	socket2@0.5.7
	spin@0.9.8
	strsim@0.11.1
	subprocess@0.2.9
	syn@2.0.69
	terminal_size@0.3.0
	text_placeholder@0.5.1
	thiserror-impl@1.0.61
	thiserror@1.0.61
	tinyvec@1.7.0
	tinyvec_macros@0.1.1
	tokio-rustls@0.24.1
	tokio@1.38.0
	toml@0.8.14
	toml_datetime@0.6.6
	toml_edit@0.22.14
	tracing-attributes@0.1.27
	tracing-core@0.1.32
	tracing@0.1.40
	unicode-bidi@0.3.15
	unicode-ident@1.0.12
	unicode-normalization@0.1.23
	untrusted@0.9.0
	url@2.5.2
	utf8parse@0.2.2
	value-bag@1.9.0
	version_check@0.9.4
	wait-timeout@0.2.0
	waker-fn@1.2.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.92
	wasm-bindgen-futures@0.4.42
	wasm-bindgen-macro-support@0.2.92
	wasm-bindgen-macro@0.2.92
	wasm-bindgen-shared@0.2.92
	wasm-bindgen@0.2.92
	web-sys@0.3.69
	widestring@1.1.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.6.13
	winreg@0.50.0
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
"

inherit cargo

DESCRIPTION="The Modern Port Scanner"
HOMEPAGE="https://github.com/RustScan/RustScan"
SRC_URI="https://github.com/RustScan/RustScan/archive/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/RustScan-${PV}"
LICENSE="MIT"
LICENSE+="
	BSD ISC MIT MPL-2.0 Unicode-DFS-2016
	|| ( Apache-2.0 Boost-1.0 )
"
SLOT="0"
KEYWORDS="~amd64"
IUSE="nmap"
RDEPEND="nmap? ( net-analyzer/nmap )"

src_test() {
	ewarn "Please note that:"
	ewarn "'qwertyuiop: command not found'"
	ewarn "is expected when you run tests"
	# those tests require the network
	if has network-sandbox ${FEATURES} ; then
		local skip=(
			--skip address::tests::parse_correct_host_addresses
			--skip address::tests::parse_hosts_file_and_incorrect_hosts
			--skip address::tests::resolver_args_google_dns
			--skip address::tests::resolver_default_cloudflare
		)
	fi

	cargo_src_test -- "${skip[@]}"
}
