# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8
PYTHON_COMPAT=( python3_{9..12} )

inherit cmake python-single-r1

DESCRIPTION="IEEE 802.15.4 ZigBee Transceiver"
HOMEPAGE="https://github.com/bastibl/gr-ieee802-15-4"

if [[ ${PV} == 9999* ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/bastibl/gr-ieee802-15-4.git"
	EGIT_BRANCH="maint-3.9"
else
	COMMIT="1a2999ce2778df279870f028a4ce15d94e60fbd9"
	SRC_URI="https://github.com/bastibl/gr-ieee802-15-4/archive/${COMMIT}.tar.gz -> ${P}.tar.gz"
	S="${WORKDIR}/gr-ieee802-15-4-${COMMIT}"
	KEYWORDS="~amd64 ~x86"
fi

LICENSE="GPL-3"
SLOT="0/${PV}"

RDEPEND="net-wireless/gnuradio:0=[${PYTHON_SINGLE_USEDEP}]
	$(python_gen_cond_dep '
		dev-libs/boost:=[python,${PYTHON_USEDEP}]
		dev-python/pybind11[${PYTHON_USEDEP}]
	')
	dev-libs/gmp
	dev-libs/spdlog:=
	sci-libs/volk:=
	${PYTHON_DEPS}"
DEPEND="${RDEPEND}"
BDEPEND="dev-lang/swig"

REQUIRED_USE="${PYTHON_REQUIRED_USE}"

src_prepare() {
	#although cppunit is not used, it fails if it isn't there, fix it
	sed -i 's#FATAL_ERROR "CppUnit#MESSAGE "CppUnit#' CMakeLists.txt
	sed -i '/${CPPUNIT_INCLUDE_DIRS}/d' CMakeLists.txt
	sed -i '/${CPPUNIT_LIBRARY_DIRS}/d' CMakeLists.txt
	sed -i '/GR_PKG_DOC_DIR/d' CMakeLists.txt
	cmake_src_prepare
}

src_configure() {
	local mycmakeargs=(
		-DPYTHON_EXECUTABLE="${PYTHON}"
		-DGR_PKG_DOC_DIR="/usr/share/doc/${P}"
	)
	cmake_src_configure
}

src_install() {
	cmake_src_install
	# Remove stray python files generated by the build system
	find "${ED}" -name '*.pyc' -exec rm -f {} \; || die
	find "${ED}" -name '*.pyo' -exec rm -f {} \; || die
	python_optimize
}
