# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{10..12} )

inherit distutils-r1

DESCRIPTION="Python interface for the SAM/BAM sequence alignment and mapping format"
HOMEPAGE="
	https://github.com/pysam-developers/pysam
	https://pypi.org/project/pysam/"
SRC_URI="https://github.com/pysam-developers/pysam/archive/v${PV}.tar.gz -> ${P}.gh.tar.gz"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64 ~x86"

RDEPEND="=sci-libs/htslib-1.20*:="
DEPEND="${RDEPEND}
	dev-python/setuptools[${PYTHON_USEDEP}]"
BDEPEND="
	dev-python/cython[${PYTHON_USEDEP}]
	test? (
		=sci-biology/bcftools-1.20*
		=sci-biology/samtools-1.20*
	)"

distutils_enable_tests pytest

DISTUTILS_IN_SOURCE_BUILD=1

EPYTEST_DESELECT=(
	# only work with bundled htslib
	'tests/tabix_test.py::TestRemoteFileHTTP'
	'tests/tabix_test.py::TestRemoteFileHTTPWithHeader'

	'tests/AlignedSegment_test.py::TestBaseModifications'
)

python_prepare_all() {
	# unbundle htslib
	export HTSLIB_MODE="external"
	export HTSLIB_INCLUDE_DIR="${ESYSROOT}"/usr/include
	export HTSLIB_LIBRARY_DIR="${ESYSROOT}"/usr/$(get_libdir)
	rm -r htslib || die

	# prevent setup.py from adding RPATHs (except $ORIGIN)
	sed -e '/runtime_library_dirs=htslib_library_dirs/d' \
		-i setup.py || die

	if use test; then
		einfo "Building test data"
		emake -C tests/pysam_data
		emake -C tests/cbcf_data
	fi

	distutils-r1_python_prepare_all
}

python_compile() {
	# breaks with parallel build
	# need to avoid dropping .so plugins into
	# build-lib, which breaks tests
	esetup.py build_ext --inplace -j1
	distutils-r1_python_compile -j1
}
