# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.12.1

EAPI=8

CRATES="
	ab_glyph@0.2.23
	ab_glyph_rasterizer@0.1.8
	accesskit@0.12.2
	adler@1.0.2
	ahash@0.8.7
	aho-corasick@1.1.2
	android-activity@0.5.2
	android-properties@0.2.2
	anyhow@1.0.79
	arboard@3.3.0
	arc-swap@1.6.0
	as-raw-xcb-connection@1.0.1
	atomic-waker@1.1.2
	autocfg@1.1.0
	base64@0.21.7
	bitflags@1.3.2
	bitflags@2.4.2
	block-buffer@0.10.4
	block-sys@0.2.1
	block2@0.3.0
	block@0.1.6
	bstr@1.9.0
	btoi@0.4.3
	bumpalo@3.14.0
	bytemuck@1.14.1
	bytemuck_derive@1.5.0
	byteorder@1.5.0
	bytes@1.5.0
	calloop-wayland-source@0.2.0
	calloop@0.12.4
	cc@1.0.83
	cesu8@1.1.0
	cfg-if@1.0.0
	cfg_aliases@0.1.1
	cgl@0.3.2
	clipboard-win@4.5.0
	clru@0.6.1
	cocoa-foundation@0.1.2
	cocoa@0.25.0
	color_quant@1.1.0
	combine@4.6.6
	concurrent-queue@2.4.0
	core-foundation-sys@0.8.6
	core-foundation@0.9.4
	core-graphics-types@0.1.3
	core-graphics@0.23.1
	cpufeatures@0.2.12
	crc32fast@1.3.2
	crossbeam-channel@0.5.11
	crossbeam-utils@0.8.19
	crossterm@0.25.0
	crossterm_winapi@0.9.1
	crypto-common@0.1.6
	cursive@0.20.0
	cursive_core@0.3.7
	cursor-icon@1.1.0
	darling@0.20.5
	darling_core@0.20.5
	darling_macro@0.20.5
	dashmap@5.5.3
	deranged@0.3.11
	digest@0.10.7
	directories-next@2.0.0
	dirs-sys-next@0.1.2
	dispatch@0.2.0
	displaydoc@0.2.4
	dlib@0.5.2
	downcast-rs@1.2.0
	dunce@1.0.4
	ecolor@0.25.0
	eframe@0.25.0
	egui-winit@0.25.0
	egui@0.25.0
	egui_glow@0.25.0
	egui_plot@0.25.0
	emath@0.25.0
	enum-map-derive@0.17.0
	enum-map@2.7.3
	enumn@0.1.13
	enumset@1.1.3
	enumset_derive@0.8.1
	epaint@0.25.0
	equivalent@1.0.1
	errno@0.3.8
	error-code@2.3.1
	faster-hex@0.9.0
	fastrand@2.0.1
	fdeflate@0.3.4
	find-crate@0.6.3
	flate2@1.0.28
	fluent-bundle@0.15.2
	fluent-langneg@0.13.0
	fluent-syntax@0.11.0
	fluent@0.16.0
	fnv@1.0.7
	foreign-types-macros@0.2.3
	foreign-types-shared@0.3.1
	foreign-types@0.5.0
	form_urlencoded@1.2.1
	generic-array@0.14.7
	gethostname@0.3.0
	gethostname@0.4.3
	getrandom@0.2.12
	gix-actor@0.28.1
	gix-chunk@0.4.7
	gix-commitgraph@0.22.1
	gix-config-value@0.14.4
	gix-config@0.31.0
	gix-date@0.8.3
	gix-diff@0.37.0
	gix-discover@0.26.0
	gix-features@0.36.1
	gix-fs@0.8.1
	gix-glob@0.14.1
	gix-hash@0.13.3
	gix-hashtable@0.4.1
	gix-lock@11.0.1
	gix-macros@0.1.3
	gix-object@0.38.0
	gix-odb@0.54.0
	gix-pack@0.44.0
	gix-path@0.10.5
	gix-quote@0.4.10
	gix-ref@0.38.0
	gix-refspec@0.19.0
	gix-revision@0.23.0
	gix-revwalk@0.9.0
	gix-sec@0.10.4
	gix-tempfile@11.0.1
	gix-trace@0.1.7
	gix-traverse@0.34.0
	gix-url@0.25.2
	gix-utils@0.1.9
	gix-validate@0.8.3
	gix@0.55.2
	gl_generator@0.14.0
	glow@0.13.1
	glutin-winit@0.4.2
	glutin@0.31.2
	glutin_egl_sys@0.6.0
	glutin_glx_sys@0.5.0
	glutin_wgl_sys@0.5.0
	hashbrown@0.14.3
	home@0.5.9
	i18n-config@0.4.6
	i18n-embed-fl@0.7.0
	i18n-embed-impl@0.8.3
	i18n-embed@0.14.1
	icrate@0.0.4
	ident_case@1.0.1
	idna@0.5.0
	image@0.24.8
	indexmap@2.2.2
	intl-memoizer@0.5.1
	intl_pluralrules@7.0.2
	itoa@1.0.10
	jni-sys@0.3.0
	jni@0.21.1
	jobserver@0.1.27
	js-sys@0.3.67
	khronos_api@3.1.0
	lazy_static@1.4.0
	libc@0.2.153
	libloading@0.8.1
	libredox@0.0.1
	libredox@0.0.2
	linux-raw-sys@0.4.13
	locale_config@0.3.0
	lock_api@0.4.11
	log@0.4.20
	malloc_buf@0.0.6
	memchr@2.7.1
	memmap2@0.7.1
	memmap2@0.9.4
	memoffset@0.7.1
	miniz_oxide@0.7.2
	mio@0.8.10
	ndk-context@0.1.1
	ndk-sys@0.5.0+25.2.9519653
	ndk@0.8.0
	nix@0.26.4
	nohash-hasher@0.2.0
	num-complex@0.4.4
	num-conv@0.1.0
	num-integer@0.1.45
	num-iter@0.1.43
	num-rational@0.4.1
	num-traits@0.2.17
	num@0.4.1
	num_enum@0.7.2
	num_enum_derive@0.7.2
	num_threads@0.1.6
	objc-foundation@0.1.1
	objc-sys@0.3.2
	objc2-encode@3.0.0
	objc2@0.4.1
	objc@0.2.7
	objc_id@0.1.1
	once_cell@1.19.0
	orbclient@0.3.47
	owned_ttf_parser@0.20.0
	owning_ref@0.4.1
	parking_lot@0.12.1
	parking_lot_core@0.9.9
	percent-encoding@2.3.1
	pin-project-lite@0.2.13
	pkg-config@0.3.29
	png@0.17.11
	polling@3.3.2
	powerfmt@0.2.0
	proc-macro-crate@3.1.0
	proc-macro-error-attr@1.0.4
	proc-macro-error@1.0.4
	proc-macro2@1.0.78
	prodash@26.2.2
	quick-xml@0.31.0
	quote@1.0.35
	raw-window-handle@0.5.2
	redox_syscall@0.3.5
	redox_syscall@0.4.1
	redox_users@0.4.4
	regex-automata@0.4.5
	regex-syntax@0.8.2
	regex@1.10.3
	ron@0.8.1
	rust-embed-impl@8.2.0
	rust-embed-utils@8.2.0
	rust-embed@8.2.0
	rustc-hash@1.1.0
	rustix@0.38.31
	ryu@1.0.16
	same-file@1.0.6
	scoped-tls@1.0.1
	scopeguard@1.2.0
	self_cell@0.10.3
	self_cell@1.0.3
	serde@1.0.196
	serde_derive@1.0.196
	serde_json@1.0.113
	serde_spanned@0.6.5
	sha1_smol@1.0.0
	sha2@0.10.8
	signal-hook-mio@0.2.3
	signal-hook-registry@1.4.1
	signal-hook@0.3.17
	simd-adler32@0.3.7
	slab@0.4.9
	slotmap@1.0.7
	smallvec@1.13.1
	smithay-client-toolkit@0.18.0
	smithay-clipboard@0.7.0
	smol_str@0.2.1
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	str-buf@1.0.6
	strsim@0.10.0
	syn@1.0.109
	syn@2.0.48
	tempfile@3.9.0
	thiserror-impl@1.0.56
	thiserror@1.0.56
	time-core@0.1.2
	time-macros@0.2.17
	time@0.3.34
	tinystr@0.7.5
	tinyvec@1.6.0
	tinyvec_macros@0.1.1
	toml@0.5.11
	toml@0.8.9
	toml_datetime@0.6.5
	toml_edit@0.21.1
	tracing-core@0.1.32
	tracing@0.1.40
	ttf-parser@0.20.0
	type-map@0.4.0
	typenum@1.17.0
	unic-langid-impl@0.9.4
	unic-langid@0.9.4
	unicode-bidi@0.3.15
	unicode-bom@2.0.3
	unicode-ident@1.0.12
	unicode-normalization@0.1.22
	unicode-segmentation@1.10.1
	unicode-width@0.1.11
	url@2.5.0
	version_check@0.9.4
	walkdir@2.4.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.90
	wasm-bindgen-futures@0.4.40
	wasm-bindgen-macro-support@0.2.90
	wasm-bindgen-macro@0.2.90
	wasm-bindgen-shared@0.2.90
	wasm-bindgen@0.2.90
	wayland-backend@0.3.3
	wayland-client@0.31.2
	wayland-csd-frame@0.3.0
	wayland-cursor@0.31.1
	wayland-protocols-plasma@0.2.0
	wayland-protocols-wlr@0.2.0
	wayland-protocols@0.31.2
	wayland-scanner@0.31.1
	wayland-sys@0.31.1
	web-sys@0.3.67
	web-time@0.2.4
	webbrowser@0.8.12
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.6
	winapi-wsapoll@0.1.1
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.45.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-targets@0.42.2
	windows-targets@0.48.5
	windows-targets@0.52.0
	windows_aarch64_gnullvm@0.42.2
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.0
	windows_aarch64_msvc@0.42.2
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.0
	windows_i686_gnu@0.42.2
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.0
	windows_i686_msvc@0.42.2
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.0
	windows_x86_64_gnu@0.42.2
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.0
	windows_x86_64_gnullvm@0.42.2
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.0
	windows_x86_64_msvc@0.42.2
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.0
	winit@0.29.10
	winnow@0.5.37
	x11-dl@2.21.0
	x11rb-protocol@0.12.0
	x11rb-protocol@0.13.0
	x11rb@0.12.0
	x11rb@0.13.0
	xcursor@0.3.5
	xi-unicode@0.3.0
	xkbcommon-dl@0.4.1
	xkeysym@0.2.0
	xml-rs@0.8.19
	zerocopy-derive@0.7.32
	zerocopy@0.7.32
"

declare -A GIT_CRATES=(
	[libdrm_amdgpu_sys]='https://github.com/Umio-Yasuno/libdrm-amdgpu-sys-rs;6852a973c639385988ce0454b59dddcf40ebcd2f;libdrm-amdgpu-sys-rs-%commit%'
)

# Box Time T 1.80 stuff
RUST_MAX_VER="1.79.0"

inherit desktop cargo

DESCRIPTION="Tool to displays AMDGPU usage."
HOMEPAGE="https://github.com/Umio-Yasuno/amdgpu_top"
SRC_URI="
	https://github.com/Umio-Yasuno/amdgpu_top/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD Boost-1.0 ISC MIT OFL-1.1 Unicode-DFS-2016 ZLIB
"
# tinystr
LICENSE+="
	Apache-2.0 MIT
"

SLOT="0"
KEYWORDS="~amd64"

IUSE="man"

BDEPEND="
	man? (
		|| (
			app-text/lowdown
			virtual/pandoc
		)
	)
"

QA_PRESTRIPPED="/usr/bin/amdgpu_top"

DOCS=(
	README.md
)

src_compile() {
	cargo_src_compile

	if use man; then
		local docgen=lowdown

		# prefer pandoc if it's installed
		has_version virtual/pandoc && docgen=pandoc

		"${docgen}" docs/man.${PN}.md -s -t man -o docs/${PN}.1 \
			|| die "failed to generate man page with ${docgen}"
	fi
}

src_install() {
	cargo_src_install

	use man && doman docs/${PN}.1
	domenu assets/*.desktop
	dodoc "${DOCS[@]}" docs/*
}
