# Copyright 2024-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.2

EAPI=8

CRATES="
	addr2line@0.20.0
	adler@1.0.2
	ahash@0.8.11
	aho-corasick@1.1.2
	allocator-api2@0.2.14
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anyhow@1.0.86
	arc-swap@1.7.1
	autocfg@1.1.0
	backtrace@0.3.68
	bitflags@1.3.2
	bitflags@2.6.0
	bstr@1.8.0
	bumpalo@3.12.0
	bytes@1.4.0
	cassowary@0.3.0
	cc@1.0.106
	cfg-if@1.0.0
	chardetng@0.1.17
	chrono@0.4.38
	clipboard-win@5.4.0
	clru@0.6.1
	codespan-reporting@0.11.1
	content_inspector@0.2.4
	core-foundation-sys@0.8.4
	cov-mark@1.1.0
	crc32fast@1.3.2
	crossbeam-channel@0.5.8
	crossbeam-deque@0.8.3
	crossbeam-epoch@0.9.15
	crossbeam-utils@0.8.16
	crossterm@0.27.0
	crossterm_winapi@0.9.1
	cxx-build@1.0.94
	cxx@1.0.94
	cxxbridge-flags@1.0.94
	cxxbridge-macro@1.0.94
	dashmap@5.4.0
	deranged@0.3.11
	dunce@1.0.4
	either@1.9.0
	encoding_rs@0.8.34
	encoding_rs_io@0.1.7
	equivalent@1.0.0
	errno@0.3.8
	error-code@3.0.0
	etcetera@0.8.0
	faster-hex@0.9.0
	fastrand@2.1.0
	fern@0.6.2
	filedescriptor@0.8.2
	filetime@0.2.23
	flate2@1.0.27
	fnv@1.0.7
	form_urlencoded@1.2.1
	futures-core@0.3.30
	futures-executor@0.3.30
	futures-task@0.3.30
	futures-util@0.3.30
	getrandom@0.2.9
	gimli@0.27.3
	gix-actor@0.31.2
	gix-attributes@0.22.2
	gix-bitmap@0.2.11
	gix-chunk@0.4.8
	gix-command@0.3.7
	gix-commitgraph@0.24.2
	gix-config-value@0.14.6
	gix-config@0.37.0
	gix-date@0.8.6
	gix-diff@0.44.0
	gix-dir@0.5.0
	gix-discover@0.32.0
	gix-features@0.38.2
	gix-filter@0.11.2
	gix-fs@0.11.0
	gix-glob@0.16.2
	gix-hash@0.14.2
	gix-hashtable@0.5.2
	gix-ignore@0.11.2
	gix-index@0.33.0
	gix-lock@14.0.0
	gix-macros@0.1.5
	gix-object@0.42.2
	gix-odb@0.61.0
	gix-pack@0.51.0
	gix-packetline-blocking@0.17.4
	gix-path@0.10.7
	gix-pathspec@0.7.5
	gix-quote@0.4.12
	gix-ref@0.44.0
	gix-refspec@0.23.0
	gix-revision@0.27.1
	gix-revwalk@0.13.1
	gix-sec@0.10.6
	gix-status@0.10.0
	gix-submodule@0.11.0
	gix-tempfile@14.0.0
	gix-trace@0.1.9
	gix-traverse@0.39.1
	gix-url@0.27.3
	gix-utils@0.1.12
	gix-validate@0.8.5
	gix-worktree@0.34.0
	gix@0.63.0
	globset@0.4.14
	grep-matcher@0.1.7
	grep-regex@0.1.12
	grep-searcher@0.1.13
	hashbrown@0.12.3
	hashbrown@0.14.5
	hermit-abi@0.2.6
	home@0.5.9
	iana-time-zone-haiku@0.1.1
	iana-time-zone@0.1.56
	idna@0.5.0
	ignore@0.4.22
	imara-diff@0.1.6
	indexmap@2.0.0
	indoc@2.0.5
	is-docker@0.2.0
	is-wsl@0.4.0
	itoa@1.0.6
	js-sys@0.3.61
	kstring@2.0.0
	libc@0.2.155
	libloading@0.8.4
	link-cplusplus@1.0.8
	linux-raw-sys@0.4.12
	lock_api@0.4.9
	log@0.4.22
	lsp-types@0.95.1
	memchr@2.6.3
	memmap2@0.9.0
	memoffset@0.9.0
	miniz_oxide@0.7.1
	mio@0.8.11
	nucleo-matcher@0.2.0
	nucleo@0.2.1
	num-conv@0.1.0
	num-traits@0.2.15
	num_cpus@1.15.0
	num_threads@0.1.6
	object@0.31.1
	once_cell@1.19.0
	open@5.2.0
	parking_lot@0.12.3
	parking_lot_core@0.9.7
	pathdiff@0.2.1
	percent-encoding@2.3.1
	pin-project-lite@0.2.12
	pin-utils@0.1.0
	powerfmt@0.2.0
	proc-macro2@1.0.76
	prodash@28.0.0
	pulldown-cmark@0.11.0
	quickcheck@1.0.3
	quote@1.0.35
	rand@0.8.5
	rand_core@0.6.4
	rayon-core@1.11.0
	rayon@1.7.0
	redox_syscall@0.2.16
	redox_syscall@0.4.1
	regex-automata@0.4.5
	regex-cursor@0.1.4
	regex-syntax@0.8.2
	regex@1.10.5
	ropey@1.6.1
	rustc-demangle@0.1.23
	rustix@0.38.34
	ryu@1.0.13
	same-file@1.0.6
	scopeguard@1.1.0
	scratch@1.0.5
	serde@1.0.204
	serde_derive@1.0.204
	serde_json@1.0.120
	serde_repr@0.1.12
	serde_spanned@0.6.6
	sha1_smol@1.0.0
	shell-words@1.1.0
	signal-hook-mio@0.2.3
	signal-hook-registry@1.4.1
	signal-hook-tokio@0.3.1
	signal-hook@0.3.17
	slab@0.4.8
	slotmap@1.0.7
	smallvec@1.13.2
	smartstring@1.0.1
	smawk@0.3.1
	socket2@0.5.5
	static_assertions@1.1.0
	str_indices@0.4.1
	syn@1.0.109
	syn@2.0.48
	tempfile@3.10.1
	termcolor@1.2.0
	termini@1.0.0
	textwrap@0.16.1
	thiserror-impl@1.0.61
	thiserror@1.0.61
	threadpool@1.8.1
	time-core@0.1.2
	time-macros@0.2.18
	time@0.3.36
	tinyvec@1.6.0
	tinyvec_macros@0.1.1
	tokio-macros@2.3.0
	tokio-stream@0.1.15
	tokio@1.38.0
	toml@0.8.14
	toml_datetime@0.6.6
	toml_edit@0.22.14
	tree-sitter@0.22.6
	unicase@2.6.0
	unicode-bidi@0.3.15
	unicode-bom@2.0.2
	unicode-general-category@0.6.0
	unicode-ident@1.0.8
	unicode-linebreak@0.1.5
	unicode-normalization@0.1.22
	unicode-segmentation@1.11.0
	unicode-width@0.1.12
	url@2.5.2
	version_check@0.9.4
	walkdir@2.4.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.84
	wasm-bindgen-macro-support@0.2.84
	wasm-bindgen-macro@0.2.84
	wasm-bindgen-shared@0.2.84
	wasm-bindgen@0.2.84
	which@6.0.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.5
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.45.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-targets@0.42.2
	windows-targets@0.48.0
	windows-targets@0.52.0
	windows@0.48.0
	windows_aarch64_gnullvm@0.42.2
	windows_aarch64_gnullvm@0.48.0
	windows_aarch64_gnullvm@0.52.0
	windows_aarch64_msvc@0.42.2
	windows_aarch64_msvc@0.48.0
	windows_aarch64_msvc@0.52.0
	windows_i686_gnu@0.42.2
	windows_i686_gnu@0.48.0
	windows_i686_gnu@0.52.0
	windows_i686_msvc@0.42.2
	windows_i686_msvc@0.48.0
	windows_i686_msvc@0.52.0
	windows_x86_64_gnu@0.42.2
	windows_x86_64_gnu@0.48.0
	windows_x86_64_gnu@0.52.0
	windows_x86_64_gnullvm@0.42.2
	windows_x86_64_gnullvm@0.48.0
	windows_x86_64_gnullvm@0.52.0
	windows_x86_64_msvc@0.42.2
	windows_x86_64_msvc@0.48.0
	windows_x86_64_msvc@0.52.0
	winnow@0.6.5
	winsafe@0.0.19
	zerocopy-derive@0.7.31
	zerocopy@0.7.31
"

inherit cargo desktop shell-completion xdg

DESCRIPTION="A post-modern text editor"
HOMEPAGE="
	https://helix-editor.com/
	https://github.com/helix-editor/helix
"
SRC_URI="
	https://github.com/helix-editor/helix/releases/download/${PV}/${P}-source.tar.xz -> ${P}.tar.xz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}"

LICENSE="MPL-2.0"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD Boost-1.0 ISC MIT MPL-2.0 MPL-2.0 Unicode-DFS-2016
	ZLIB
"
SLOT="0"
KEYWORDS="amd64"
IUSE="+grammar"

RDEPEND="dev-vcs/git"

pkg_setup() {
	QA_FLAGS_IGNORED="
		usr/bin/hx
		/usr/$(get_libdir)/helix/.*\.so
	"
	export HELIX_DEFAULT_RUNTIME="${EPREFIX}/usr/share/${PN}/runtime"
	use grammar || export HELIX_DISABLE_AUTO_GRAMMAR_BUILD=1
	rust_pkg_setup
}

src_install() {
	cargo_src_install --path helix-term

	insinto "/usr/$(get_libdir)/${PN}"
	use grammar && doins runtime/grammars/*.so
	rm -r runtime/grammars || die
	use grammar && dosym "../../../$(get_libdir)/${PN}" "${EPREFIX}/usr/share/${PN}/runtime/grammars"

	insinto /usr/share/helix
	doins -r runtime

	doicon -s 256x256 contrib/${PN}.png
	domenu contrib/Helix.desktop

	insinto /usr/share/metainfo
	doins contrib/Helix.appdata.xml

	newbashcomp contrib/completion/hx.bash hx
	newzshcomp contrib/completion/hx.zsh _hx
	dofishcomp contrib/completion/hx.fish

	DOCS=(
		README.md
		CHANGELOG.md
		docs/
	)
	HTML_DOCS=(
		book/
	)
	einstalldocs
}

pkg_postinst() {
	if ! use grammar ; then
		einfo "Grammars are not installed yet. To fetch them, run:"
		einfo ""
		einfo "  hx --grammar fetch && hx --grammar build"
	fi

	xdg_desktop_database_update
	xdg_icon_cache_update
}

pkg_postrm() {
	xdg_desktop_database_update
	xdg_icon_cache_update
}
