# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=hatchling
PYTHON_COMPAT=( pypy3 pypy3_11 python3_{10..13} )

inherit distutils-r1 pypi

DESCRIPTION="Asynchronous API for ZMQ using AnyIO"
HOMEPAGE="
	https://github.com/davidbrochart/zmq-anyio/
	https://pypi.org/project/zmq-anyio/
"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~arm ~arm64 ~hppa ~loong ~ppc ~ppc64 ~riscv ~sparc ~x86"
IUSE="test-rust"

RDEPEND="
	<dev-python/anyio-5[${PYTHON_USEDEP}]
	>=dev-python/anyio-4.8.0[${PYTHON_USEDEP}]
	<dev-python/anyioutils-0.8[${PYTHON_USEDEP}]
	>=dev-python/anyioutils-0.7.1[${PYTHON_USEDEP}]
	<dev-python/pyzmq-27[${PYTHON_USEDEP}]
	>=dev-python/pyzmq-26.0.0[${PYTHON_USEDEP}]
"
BDEPEND="
	test? (
		test-rust? (
			>=dev-python/trio-0.27.0[${PYTHON_USEDEP}]
		)
	)
"

distutils_enable_tests pytest

PATCHES=(
	# https://github.com/davidbrochart/zmq-anyio/pull/23
	"${FILESDIR}/${P}-pyzmq-cffi.patch"
)

python_test() {
	local args=()
	if ! has_version "dev-python/trio[${PYTHON_USEDEP}]"; then
		args+=( -k "not trio" )
	fi

	local -x PYTEST_DISABLE_PLUGIN_AUTOLOAD=1
	epytest -p anyio "${args[@]}"
}
