# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.5

EAPI=8

CRATES="
	adler2@2.0.0
	aho-corasick@1.1.3
	allocator-api2@0.2.21
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anes@0.1.6
	annotate-snippets@0.6.1
	anstream@0.6.18
	anstyle-lossy@1.1.3
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-svg@0.1.7
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	anyhow@1.0.96
	argfile@0.2.1
	arrayvec@0.7.6
	assert_fs@1.1.2
	autocfg@1.4.0
	base64@0.13.1
	bincode@1.3.3
	bitflags@1.3.2
	bitflags@2.8.0
	block-buffer@0.10.4
	boxcar@0.2.10
	bstr@1.11.3
	bumpalo@3.17.0
	byteorder@1.5.0
	cachedir@0.3.1
	camino@1.1.9
	cast@0.3.0
	castaway@0.2.3
	cc@1.2.11
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chic@1.2.2
	chrono@0.4.39
	ciborium-io@0.2.2
	ciborium-ll@0.2.2
	ciborium@0.2.2
	clap@4.5.30
	clap_builder@4.5.30
	clap_complete@4.5.44
	clap_complete_command@0.6.1
	clap_complete_nushell@4.5.5
	clap_derive@4.5.28
	clap_lex@0.7.4
	clearscreen@4.0.1
	codspeed-criterion-compat@2.8.0
	codspeed@2.8.0
	colorchoice@1.0.3
	colored@2.2.0
	colored@3.0.0
	compact_str@0.8.1
	console@0.15.10
	console_error_panic_hook@0.1.7
	console_log@1.0.0
	core-foundation-sys@0.8.7
	countme@3.0.1
	cpufeatures@0.2.17
	crc32fast@1.4.2
	criterion-plot@0.5.0
	criterion@0.5.1
	crossbeam-channel@0.5.14
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	crossbeam@0.8.4
	crunchy@0.2.3
	crypto-common@0.1.6
	ctrlc@3.4.5
	darling@0.20.10
	darling_core@0.20.10
	darling_macro@0.20.10
	dashmap@5.5.3
	dashmap@6.1.0
	diff@0.1.13
	difflib@0.4.0
	digest@0.10.7
	dir-test-macros@0.4.1
	dir-test@0.4.1
	dirs-sys@0.4.1
	dirs@5.0.1
	displaydoc@0.2.5
	doc-comment@0.3.3
	drop_bomb@0.1.5
	dunce@1.0.5
	dyn-clone@1.0.18
	either@1.13.0
	encode_unicode@1.0.0
	env_filter@0.1.3
	env_home@0.1.0
	env_logger@0.11.6
	equivalent@1.0.1
	errno@0.3.10
	escape8259@0.5.3
	escargot@0.5.13
	etcetera@0.8.0
	fastrand@2.3.0
	fern@0.7.1
	filetime@0.2.25
	flate2@1.0.35
	fnv@1.0.7
	foldhash@0.1.4
	form_urlencoded@1.2.1
	fs-err@2.11.0
	fsevent-sys@4.1.0
	generator@0.8.4
	generic-array@0.14.7
	getopts@0.2.21
	getrandom@0.2.15
	getrandom@0.3.1
	glob@0.3.2
	globset@0.4.15
	globwalk@0.9.1
	half@2.4.1
	hashbrown@0.14.5
	hashbrown@0.15.2
	hashlink@0.10.0
	heck@0.5.0
	hermit-abi@0.3.9
	hermit-abi@0.4.0
	home@0.5.9
	html-escape@0.2.13
	humantime@2.1.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.61
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	ident_case@1.0.1
	idna@1.0.3
	idna_adapter@1.2.0
	ignore@0.4.23
	imara-diff@0.1.8
	imperative@1.0.6
	indexmap@2.7.1
	indicatif@0.17.11
	indoc@2.0.5
	inotify-sys@0.1.5
	inotify@0.11.0
	insta-cmd@0.6.0
	insta@1.42.1
	is-docker@0.2.0
	is-macro@0.3.7
	is-terminal@0.4.15
	is-wsl@0.4.0
	is_terminal_polyfill@1.70.1
	itertools@0.10.5
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.14
	jobserver@0.1.32
	jod-thread@0.1.2
	js-sys@0.3.77
	kqueue-sys@1.0.4
	kqueue@1.0.8
	lazy_static@1.5.0
	libc@0.2.170
	libcst@1.6.0
	libcst_derive@1.6.0
	libmimalloc-sys@0.1.39
	libredox@0.1.3
	libtest-mimic@0.7.3
	linked-hash-map@0.5.6
	linux-raw-sys@0.4.15
	litemap@0.7.4
	lock_api@0.4.12
	log@0.4.26
	loom@0.7.2
	lsp-server@0.7.8
	matchers@0.1.0
	matches@0.1.10
	matchit@0.8.6
	memchr@2.7.4
	mimalloc@0.1.43
	minicov@0.3.7
	minimal-lexical@0.2.1
	miniz_oxide@0.8.3
	mio@1.0.3
	natord@1.0.9
	newtype-uuid@1.2.1
	nix@0.29.0
	nom@7.1.3
	normalize-line-endings@0.3.0
	notify-types@2.0.0
	notify@8.0.0
	nu-ansi-term@0.46.0
	nu-ansi-term@0.50.1
	num-traits@0.2.19
	num_cpus@1.16.0
	number_prefix@0.4.0
	once_cell@1.20.2
	oorandom@11.1.4
	option-ext@0.2.0
	ordermap@0.5.5
	os_pipe@1.2.1
	os_str_bytes@7.0.0
	overload@0.1.1
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	paste@1.0.15
	path-absolutize@3.1.1
	path-dedot@3.1.1
	path-slash@0.2.1
	pathdiff@0.2.3
	peg-macros@0.8.4
	peg-runtime@0.8.3
	peg@0.8.4
	pep440_rs@0.7.3
	pep508_rs@0.9.2
	percent-encoding@2.3.1
	pest@2.7.15
	pest_derive@2.7.15
	pest_generator@2.7.15
	pest_meta@2.7.15
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_shared@0.11.3
	pin-project-internal@1.1.9
	pin-project-lite@0.2.16
	pin-project@1.1.9
	pkg-config@0.3.31
	portable-atomic@1.10.0
	ppv-lite86@0.2.20
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	pretty_assertions@1.4.1
	proc-macro2@1.0.93
	pyproject-toml@0.13.4
	quick-junit@0.5.1
	quick-xml@0.37.2
	quickcheck@1.0.3
	quickcheck_macros@1.0.0
	quote@1.0.38
	rand@0.8.5
	rand@0.9.0
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.0
	rayon-core@1.12.1
	rayon@1.10.0
	redox_syscall@0.5.8
	redox_users@0.4.6
	regex-automata@0.1.10
	regex-automata@0.4.9
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	ron@0.7.1
	rust-stemmers@1.2.0
	rustc-hash@1.1.0
	rustc-hash@2.1.1
	rustix@0.38.44
	rustversion@1.0.19
	ryu@1.0.19
	same-file@1.0.6
	schemars@0.8.21
	schemars_derive@0.8.21
	scoped-tls@1.0.1
	scopeguard@1.2.0
	seahash@4.1.0
	serde-wasm-bindgen@0.6.5
	serde@1.0.218
	serde_derive@1.0.218
	serde_derive_internals@0.29.1
	serde_json@1.0.139
	serde_repr@0.1.19
	serde_spanned@0.6.8
	serde_test@1.0.177
	serde_with@3.12.0
	serde_with_macros@3.12.0
	sha2@0.10.8
	sharded-slab@0.1.7
	shellexpand@3.1.0
	shlex@1.3.0
	similar@2.7.0
	siphasher@1.0.1
	smallvec@1.14.0
	snapbox-macros@0.3.10
	snapbox@0.6.21
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	strip-ansi-escapes@0.2.1
	strsim@0.11.1
	strum@0.27.1
	strum_macros@0.27.1
	syn@1.0.109
	syn@2.0.98
	synstructure@0.13.1
	tempfile@3.17.1
	termcolor@1.4.1
	terminal_size@0.4.1
	terminfo@0.9.0
	termtree@0.5.1
	test-case-core@3.3.1
	test-case-macros@3.3.1
	test-case@3.3.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.11
	thiserror@1.0.69
	thiserror@2.0.11
	thread_local@1.1.8
	threadpool@1.8.1
	tikv-jemalloc-sys@0.6.0+5.3.0-1-ge13ca993e8ccb9ba9847cc330696e02839f328f7
	tikv-jemallocator@0.6.0
	tinystr@0.7.6
	tinytemplate@1.2.1
	tinyvec@1.8.1
	tinyvec_macros@0.1.1
	toml@0.8.20
	toml_datetime@0.6.8
	toml_edit@0.22.23
	tracing-attributes@0.1.28
	tracing-core@0.1.33
	tracing-flame@0.2.0
	tracing-indicatif@0.3.9
	tracing-log@0.2.0
	tracing-subscriber@0.3.19
	tracing-tree@0.4.0
	tracing@0.1.41
	tryfn@0.2.3
	typed-arena@2.0.2
	typenum@1.17.0
	ucd-trie@0.1.7
	unic-char-property@0.9.0
	unic-char-range@0.9.0
	unic-common@0.9.0
	unic-ucd-category@0.9.0
	unic-ucd-version@0.9.0
	unicode-ident@1.0.17
	unicode-normalization@0.1.24
	unicode-width@0.1.14
	unicode-width@0.2.0
	unicode_names2@1.3.0
	unicode_names2_generator@1.3.0
	unscanny@0.1.0
	url@2.5.4
	urlencoding@2.1.3
	utf16_iter@1.0.5
	utf8-width@0.1.7
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid-macro-internal@1.13.1
	uuid@1.13.1
	valuable@0.1.1
	version-ranges@0.1.1
	version_check@0.9.5
	vt100@0.15.2
	vte@0.11.1
	vte@0.14.1
	vte_generate_state_changes@0.1.2
	wait-timeout@0.2.0
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.13.3+wasi-0.2.2
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-futures@0.4.50
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen-test-macro@0.3.50
	wasm-bindgen-test@0.3.50
	wasm-bindgen@0.2.100
	web-sys@0.3.77
	web-time@1.1.0
	which@7.0.1
	wild@2.2.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-core@0.58.0
	windows-implement@0.58.0
	windows-interface@0.58.0
	windows-result@0.2.0
	windows-strings@0.1.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows@0.58.0
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.7.0
	winsafe@0.0.19
	wit-bindgen-rt@0.33.0
	write16@1.0.0
	writeable@0.5.5
	yansi@1.0.1
	yoke-derive@0.7.5
	yoke@0.7.5
	zerocopy-derive@0.7.35
	zerocopy-derive@0.8.14
	zerocopy@0.7.35
	zerocopy@0.8.14
	zerofrom-derive@0.1.5
	zerofrom@0.1.5
	zerovec-derive@0.10.3
	zerovec@0.10.4
	zip@0.6.6
	zstd-safe@5.0.2+zstd.1.5.2
	zstd-sys@2.0.13+zstd.1.5.6
	zstd@0.11.2+zstd.1.5.2
"

declare -A GIT_CRATES=(
	[lsp-types]='https://github.com/astral-sh/lsp-types;3512a9f33eadc5402cfab1b8f7340824c8ca1439;lsp-types-%commit%'
	[salsa-macro-rules]='https://github.com/salsa-rs/salsa;99be5d9917c3dd88e19735a82ef6bf39ba84bd7e;salsa-%commit%/components/salsa-macro-rules'
	[salsa-macros]='https://github.com/salsa-rs/salsa;99be5d9917c3dd88e19735a82ef6bf39ba84bd7e;salsa-%commit%/components/salsa-macros'
	[salsa]='https://github.com/salsa-rs/salsa;99be5d9917c3dd88e19735a82ef6bf39ba84bd7e;salsa-%commit%'
)

RUST_MIN_VER="1.83.0"

inherit shell-completion cargo

DESCRIPTION="An extremely fast Python linter, written in Rust"
HOMEPAGE="
	https://docs.astral.sh/ruff/
	https://github.com/astral-sh/ruff
"
SRC_URI="
	${CARGO_CRATE_URIS}
	https://github.com/astral-sh/ruff/archive/refs/tags/${PV}.tar.gz -> ${P}.gh.tar.gz
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD CC0-1.0 ISC MIT MPL-2.0 PSF-2 Unicode-3.0
	Unicode-DFS-2016 WTFPL-2 ZLIB
"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~loong ~riscv"

RDEPEND="
	!elibc_musl? ( !elibc_Darwin? ( !elibc_bionic? ( dev-libs/jemalloc:= ) ) )
	app-arch/zstd
"
DEPEND="
	${RDEPEND}
"

QA_FLAGS_IGNORED="usr/bin/.*"

DOCS=(
	BREAKING_CHANGES.md
	CODE_OF_CONDUCT.md
	CONTRIBUTING.md
	README.md
	assets
	docs
)

src_prepare() {
	default

	# Experimental cruft cleaner. These crates are not used by the ruff binary,
	# and when they are removed in the git repo, the lockfile is regenerated
	# and gets quite a bit smaller. Hence pycargoebuild also produces much
	# smaller CRATES= variables. Less for the user to download, fewer distfiles
	# to mirror.
	pushd crates >/dev/null || die
	rm -r ruff_{benchmark,dev} red_knot{,_server} *_wasm || die
	popd > /dev/null || die

	# tests that hang in the ebuild environment
	rm crates/ruff_annotate_snippets/tests/examples.rs || die
}

src_configure() {
	export RUSTFLAGS="${RUSTFLAGS}"
	cargo_src_configure
}

src_compile() {
	local -x ZSTD_SYS_USE_PKG_CONFIG=1
	# Gentoo bug #927338
	if use !elibc_musl && use !elibc_Darwin && use !elibc_bionic; then
		local -x CARGO_FEATURE_UNPREFIXED_MALLOC_ON_SUPPORTED_PLATFORMS=1
		local -x JEMALLOC_OVERRIDE="${ESYSROOT}/usr/$(get_libdir)"/libjemalloc.so
	fi
	cargo_src_compile --bin ruff

	local releasedir
	releasedir=$(cargo_target_dir)

	${releasedir}/ruff generate-shell-completion bash > ruff-completion.bash || die
	${releasedir}/ruff generate-shell-completion zsh > ruff-completion.zsh || die
}

src_test() {
	local -x ZSTD_SYS_USE_PKG_CONFIG=1
	# Gentoo bug #927338
	if use !elibc_musl && use !elibc_Darwin && use !elibc_bionic; then
		local -x CARGO_FEATURE_UNPREFIXED_MALLOC_ON_SUPPORTED_PLATFORMS=1
		local -x JEMALLOC_OVERRIDE="${ESYSROOT}/usr/$(get_libdir)"/libjemalloc.so
	fi
	cargo_src_test --target-dir "${PWD}"/tested-target/
}

src_install() {
	local releasedir=$(cargo_target_dir)

	dobin ${releasedir}/ruff

	newbashcomp ruff-completion.bash ruff
	newzshcomp ruff-completion.zsh _ruff

	dodoc -r "${DOCS[@]}"
}
