# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.4

EAPI=8

CRATES="
	adler2@2.0.0
	ahash@0.8.11
	allocator-api2@0.2.21
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	anyhow@1.0.96
	arc-swap@1.7.1
	autocfg@1.4.0
	bitflags@2.8.0
	bstr@1.11.3
	bzip2-rs@0.1.2
	cc@1.2.15
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	clap@4.5.30
	clap_builder@4.5.30
	clap_lex@0.7.4
	clru@0.6.2
	colorchoice@1.0.3
	crc32fast@1.4.2
	ctrlc@3.4.5
	curl-sys@0.4.80+curl-8.12.1
	curl@0.4.47
	displaydoc@0.2.5
	dunce@1.0.5
	encoding_rs@0.8.35
	equivalent@1.0.2
	errno@0.3.10
	faster-hex@0.9.0
	fastrand@2.3.0
	filetime@0.2.25
	flate2@1.0.35
	fnv@1.0.7
	form_urlencoded@1.2.1
	getrandom@0.3.1
	gix-actor@0.33.2
	gix-bitmap@0.2.14
	gix-chunk@0.4.11
	gix-command@0.4.1
	gix-commitgraph@0.26.0
	gix-config-value@0.14.11
	gix-config@0.43.0
	gix-date@0.9.3
	gix-diff@0.50.0
	gix-discover@0.38.0
	gix-features@0.40.0
	gix-fs@0.13.0
	gix-glob@0.18.0
	gix-hash@0.16.0
	gix-hashtable@0.7.0
	gix-index@0.38.0
	gix-lock@16.0.0
	gix-object@0.47.0
	gix-odb@0.67.0
	gix-pack@0.57.0
	gix-packetline@0.18.3
	gix-path@0.10.14
	gix-protocol@0.48.0
	gix-quote@0.4.15
	gix-ref@0.50.0
	gix-refspec@0.28.0
	gix-revision@0.32.0
	gix-revwalk@0.18.0
	gix-sec@0.10.11
	gix-shallow@0.2.0
	gix-tempfile@16.0.0
	gix-trace@0.1.12
	gix-transport@0.45.0
	gix-traverse@0.44.0
	gix-url@0.29.0
	gix-utils@0.1.14
	gix-validate@0.9.3
	gix@0.70.0
	hashbrown@0.14.5
	hashbrown@0.15.2
	hermit-abi@0.4.0
	home@0.5.11
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	indexmap@2.7.1
	is-terminal@0.4.15
	is_terminal_polyfill@1.70.1
	itoa@1.0.14
	jiff-tzdb-platform@0.1.2
	jiff-tzdb@0.1.2
	jiff@0.1.29
	jiff@0.2.1
	libc@0.2.169
	libredox@0.1.3
	libz-sys@1.1.21
	linux-raw-sys@0.4.15
	litemap@0.7.4
	lock_api@0.4.12
	log@0.4.26
	maybe-async@0.2.10
	memchr@2.7.4
	memmap2@0.9.5
	miniz_oxide@0.8.5
	nix@0.29.0
	once_cell@1.20.3
	openssl-probe@0.1.6
	openssl-sys@0.9.106
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	percent-encoding@2.3.1
	pkg-config@0.3.31
	portable-atomic-util@0.2.4
	portable-atomic@1.10.0
	proc-macro2@1.0.93
	prodash@29.0.0
	quote@1.0.38
	redox_syscall@0.5.9
	regex-automata@0.4.9
	rustix@0.38.44
	ryu@1.0.19
	same-file@1.0.6
	schannel@0.1.27
	scopeguard@1.2.0
	serde@1.0.218
	serde_derive@1.0.218
	serde_json@1.0.139
	sha1_smol@1.0.1
	shell-words@1.1.0
	shlex@1.3.0
	smallvec@1.14.0
	socket2@0.5.8
	stable_deref_trait@1.2.0
	strsim@0.11.1
	syn@2.0.98
	synstructure@0.13.1
	tar@0.4.44
	tempfile@3.17.1
	termcolor@1.4.1
	terminal_size@0.4.1
	thiserror-impl@2.0.11
	thiserror@2.0.11
	tinystr@0.7.6
	tinyvec@1.8.1
	tinyvec_macros@0.1.1
	unicode-bom@2.0.3
	unicode-ident@1.0.17
	unicode-normalization@0.1.24
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.2
	vcpkg@0.2.15
	version_check@0.9.5
	walkdir@2.5.0
	wasi@0.13.3+wasi-0.2.2
	winapi-util@0.1.9
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	winnow@0.6.26
	winnow@0.7.3
	wit-bindgen-rt@0.33.0
	write16@1.0.0
	writeable@0.5.5
	xattr@1.4.0
	yoke-derive@0.7.5
	yoke@0.7.5
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
	zerofrom-derive@0.1.5
	zerofrom@0.1.5
	zerovec-derive@0.10.3
	zerovec@0.10.4
"

inherit cargo flag-o-matic

DESCRIPTION="Stack-based patch management for Git"
HOMEPAGE="https://stacked-git.github.io/"
SRC_URI="${CARGO_CRATE_URIS}"
SRC_URI+=" https://github.com/stacked-git/stgit/releases/download/v${PV}/${P}.tar.gz"

LICENSE="GPL-2"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT Unicode-DFS-2016"
SLOT="0/2"
KEYWORDS="~amd64 ~arm ~arm64 ~ppc ~ppc64 ~riscv ~x86"
IUSE="doc"

DEPEND="doc? ( app-text/asciidoc )"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/stg"

src_configure() {
	filter-lto #bug 897692
}

src_compile() {
	cargo_src_compile
	emake completion
	emake contrib
	use doc && emake doc
}

src_install() {
	cargo_src_install
	emake DESTDIR="${D}" prefix="/usr" install-completion
	emake DESTDIR="${D}" prefix="/usr" install-contrib
	if use doc; then
		emake DESTDIR="${D}" prefix="/usr" install-man
		emake DESTDIR="${D}" prefix="/usr" \
			htmldir="/usr/share/doc/${PF}"  \
			install-html
	fi
}
