# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit vala autotools

DESCRIPTION="LXDE session manager"
HOMEPAGE="https://wiki.lxde.org/en/LXSession"
SRC_URI="https://downloads.sourceforge.net/lxde/${P}.tar.xz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~ppc ~riscv ~x86 ~x86-linux"
IUSE="nls upower"

COMMON_DEPEND="
	dev-libs/dbus-glib
	dev-libs/glib:2
	>=lxde-base/lxde-common-0.99.2-r1
	sys-apps/dbus
	sys-auth/polkit
	x11-libs/cairo
	x11-libs/gdk-pixbuf:2
	x11-libs/gtk+:3
	x11-libs/libX11
"
RDEPEND="${COMMON_DEPEND}
	!lxde-base/lxsession-edit
	sys-apps/lsb-release
	upower? ( sys-power/upower )
"
DEPEND="${COMMON_DEPEND}
	x11-base/xorg-proto
"
BDEPEND="
	$(vala_depend)
	dev-util/intltool
	sys-devel/gettext
	virtual/pkgconfig
"

PATCHES=(
	# Fedora patches
	"${FILESDIR}"/${PN}-0.5.2-reload.patch
	"${FILESDIR}"/${PN}-0.5.2-notify-daemon-default.patch
	"${FILESDIR}"/${PN}-0.5.5-c99.patch
)

src_prepare() {
	rm *.stamp || die
	vala_setup
	default
	eautoreconf
}

src_configure() {
	# dbus is used for restart/shutdown (logind), and suspend/hibernate (UPower)
	econf \
		$(use_enable nls) \
		--enable-gtk3
}
