# Copyright 2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6

EAPI=8

CRATES="
	adler@1.0.2
	anyhow@1.0.71
	attohttpc@0.24.1
	attohttpc@0.25.0
	autocfg@1.1.0
	bitflags@1.3.2
	bytes@1.4.0
	cc@1.0.79
	cfg-if@1.0.0
	core-foundation-sys@0.8.4
	core-foundation@0.9.3
	crc32fast@1.3.2
	darling@0.14.4
	darling_core@0.14.4
	darling_macro@0.14.4
	dbus@0.9.7
	derive_is_enum_variant@0.1.1
	dirs-sys@0.4.1
	dirs@5.0.1
	enum-kinds@0.5.1
	equivalent@1.0.1
	errno-dragonfly@0.1.2
	errno@0.3.1
	fastrand@1.9.0
	flate2@1.0.26
	fnv@1.0.7
	foreign-types-shared@0.1.1
	foreign-types@0.3.2
	form_urlencoded@1.2.0
	from_variants@1.0.2
	from_variants_impl@1.0.2
	getrandom@0.2.10
	hashbrown@0.14.0
	heck@0.3.3
	hermit-abi@0.3.2
	http@0.2.9
	ident_case@1.0.1
	idna@0.4.0
	indexmap@2.0.0
	instant@0.1.12
	io-lifetimes@1.0.11
	itoa@1.0.8
	lazy_static@1.4.0
	libc@0.2.147
	libdbus-sys@0.2.5
	linux-raw-sys@0.3.8
	listenbrainz@0.7.0
	log@0.4.19
	md5@0.7.0
	memchr@2.5.0
	miniz_oxide@0.7.1
	mpris@2.0.1
	native-tls@0.2.11
	once_cell@1.18.0
	openssl-macros@0.1.1
	openssl-probe@0.1.5
	openssl-sys@0.9.90
	openssl@0.10.55
	option-ext@0.2.0
	percent-encoding@2.3.0
	pkg-config@0.3.27
	proc-macro2@1.0.64
	quote@0.3.15
	quote@1.0.29
	redox_syscall@0.2.16
	redox_syscall@0.3.5
	redox_users@0.4.3
	rpassword@7.2.0
	rtoolbox@0.0.1
	rustfm-scrobble-proxy@2.0.0
	rustix@0.37.23
	ryu@1.0.14
	schannel@0.1.22
	security-framework-sys@2.9.0
	security-framework@2.9.1
	serde@1.0.171
	serde_derive@1.0.171
	serde_json@1.0.102
	serde_spanned@0.6.3
	serde_urlencoded@0.7.1
	strsim@0.10.0
	syn@0.11.11
	syn@1.0.109
	syn@2.0.25
	synom@0.11.3
	tempfile@3.6.0
	thiserror-impl@1.0.43
	thiserror@1.0.43
	tinyvec@1.6.0
	tinyvec_macros@0.1.1
	toml@0.7.6
	toml_datetime@0.6.3
	toml_edit@0.19.12
	unicode-bidi@0.3.13
	unicode-ident@1.0.10
	unicode-normalization@0.1.22
	unicode-segmentation@1.10.1
	unicode-xid@0.0.4
	url@2.4.0
	vcpkg@0.2.15
	wasi@0.11.0+wasi-snapshot-preview1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.48.0
	windows-targets@0.48.1
	windows_aarch64_gnullvm@0.48.0
	windows_aarch64_msvc@0.48.0
	windows_i686_gnu@0.48.0
	windows_i686_msvc@0.48.0
	windows_x86_64_gnu@0.48.0
	windows_x86_64_gnullvm@0.48.0
	windows_x86_64_msvc@0.48.0
	winnow@0.4.9
	wrapped-vec@0.3.0
"

inherit cargo systemd

DESCRIPTION="MPRIS music scrobbler daemon"
HOMEPAGE="https://github.com/InputUsername/rescrobbled"
SRC_URI="https://github.com/InputUsername/rescrobbled/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}"

LICENSE="GPL-3"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT MPL-2.0 Unicode-DFS-2016"
SLOT="0"
KEYWORDS="amd64"

RDEPEND="dev-libs/openssl:=
	sys-apps/dbus"

# https://github.com/InputUsername/rescrobbled/issues/109
RESTRICT="test"

QA_FLAGS_IGNORED="/usr/bin/rescrobbled"

src_install() {
	cargo_src_install
	einstalldocs

	systemd_dounit "${S}"/rescrobbled.service

	dodoc "${FILESDIR}"/config.toml
	docompress -x "/usr/share/doc/${PF}/config.toml"

	dodoc -r "${S}"/filter-script-examples
}

pkg_postinst() {
	if [[ -z "${REPLACING_VERSIONS}" ]]; then
		elog "Sample configuration file has been installed to "
		elog "  /usr/share/doc/rescrobbled-${PVR}/config.toml"
		elog ""
		elog "Use the sample, or launch rescrobbled to create a new empty one."
		elog ""
	fi
}
