# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{10..13} )

#https://github.com/gnuradio/volk/issues/383
CMAKE_BUILD_TYPE="None"
inherit cmake python-single-r1

DESCRIPTION="vector optimized library of kernels"
HOMEPAGE="http://libvolk.org"

if [[ "${PV}" == "9999" ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/gnuradio/volk.git"
else
	SRC_URI="https://github.com/gnuradio/volk/releases/download/v${PV}/${P}.tar.xz"
	KEYWORDS="~amd64 ~arm ~riscv ~x86"
fi

LICENSE="GPL-3"
SLOT="0/$(ver_cut 1-2)"
IUSE="orc test"

REQUIRED_USE="${PYTHON_REQUIRED_USE}"
RDEPEND="${PYTHON_DEPS}
	orc? ( dev-lang/orc )"
DEPEND="${RDEPEND}
	$(python_gen_cond_dep 'dev-python/mako[${PYTHON_USEDEP}]')"

RESTRICT="!test? ( test )"

src_configure() {
	local mycmakeargs=(
		-DENABLE_ORC=$(usex orc)
		-DPYTHON_EXECUTABLE="${PYTHON}"
		-DENABLE_TESTING="$(usex test)"
		-DENABLE_PROFILING=OFF
	)
	cmake_src_configure
}

src_install() {
	cmake_src_install
	# Remove stray python files generated by the build system
	find "${ED}" -name '*.pyc' -exec rm -f {} \; || die
	find "${ED}" -name '*.pyo' -exec rm -f {} \; || die
	python_optimize
}

src_test() {
	local myctestargs=(
		-E "(check_lgpl)"
	)
	cmake_src_test
}
