# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.12.1

EAPI=8

CRATES=""
declare -A GIT_CRATES=(
	[libdrm_amdgpu_sys]='https://github.com/Umio-Yasuno/libdrm-amdgpu-sys-rs;6852a973c639385988ce0454b59dddcf40ebcd2f;libdrm-amdgpu-sys-rs-%commit%'
)

# Box Time T 1.80 stuff
RUST_MAX_VER="1.79.0"

inherit desktop cargo

DESCRIPTION="Tool to displays AMDGPU usage."
HOMEPAGE="https://github.com/Umio-Yasuno/amdgpu_top"
SRC_URI="
	https://github.com/Umio-Yasuno/amdgpu_top/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${CARGO_CRATE_URIS}
"
SRC_URI+=" https://github.com/gentoo-crate-dist/${PN}/releases/download/v${PV}/${PN}-v${PV}-crates.tar.xz"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD Boost-1.0 ISC MIT OFL-1.1 Unicode-DFS-2016 ZLIB
"
# tinystr
LICENSE+="
	Apache-2.0 MIT
"

SLOT="0"
KEYWORDS="~amd64"

IUSE="man"

BDEPEND="
	man? (
		|| (
			app-text/lowdown
			virtual/pandoc
		)
	)
"

QA_PRESTRIPPED="/usr/bin/amdgpu_top"

DOCS=(
	README.md
)

src_compile() {
	cargo_src_compile

	if use man; then
		local docgen=lowdown

		# prefer pandoc if it's installed
		has_version virtual/pandoc && docgen=pandoc

		"${docgen}" docs/man.${PN}.md -s -t man -o docs/${PN}.1 \
			|| die "failed to generate man page with ${docgen}"
	fi
}

src_install() {
	cargo_src_install

	use man && doman docs/${PN}.1
	domenu assets/*.desktop
	dodoc "${DOCS[@]}" docs/*
}
